/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.densityfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record FunkyTestDensityFunction(DensityFunction input) implements DensityFunction
{
    private static final MapCodec<FunkyTestDensityFunction> DATA_CODEC = RecordCodecBuilder.mapCodec(record -> record.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(FunkyTestDensityFunction::input)).apply((Applicative)record, FunkyTestDensityFunction::new));
    public static final KeyDispatchDataCodec<FunkyTestDensityFunction> CODEC = KeyDispatchDataCodec.of(DATA_CODEC);

    private double transform(double value, int x, int y, int z) {
        int roundedX = x / 50;
        int roundedZ = z / 50;
        if (Math.floorMod(roundedX + roundedZ, 2) > 0) {
            return value + 0.1;
        }
        return value - 0.1;
    }

    public double compute(DensityFunction.FunctionContext context) {
        return this.transform(this.input.compute(context), context.blockX(), context.blockX(), context.blockZ());
    }

    public void fillArray(double[] array, DensityFunction.ContextProvider contextProvider) {
        this.input().fillArray(array, contextProvider);
        for (int i = 0; i < array.length; ++i) {
            DensityFunction.FunctionContext context = contextProvider.forIndex(i);
            array[i] = this.transform(array[i], context.blockX(), context.blockX(), context.blockZ());
        }
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new FunkyTestDensityFunction(this.input.mapAll(visitor)));
    }

    public double minValue() {
        return this.input.minValue() - 0.5;
    }

    public double maxValue() {
        return this.input.maxValue() + 0.5;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

