/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.biomemodifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeSpecialEffectsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record ChangeColorsBiomeModifier(HolderSet<Biome> biomes, Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> skyColor, Optional<Integer> grassColor, Optional<Integer> foliageColor) implements BiomeModifier
{
    public static final MapCodec<ChangeColorsBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ChangeColorsBiomeModifier::biomes), (App)Codec.INT.optionalFieldOf("fog_color").forGetter(ChangeColorsBiomeModifier::fogColor), (App)Codec.INT.optionalFieldOf("water_color").forGetter(ChangeColorsBiomeModifier::waterColor), (App)Codec.INT.optionalFieldOf("water_fog_color").forGetter(ChangeColorsBiomeModifier::waterFogColor), (App)Codec.INT.optionalFieldOf("sky_color").forGetter(ChangeColorsBiomeModifier::skyColor), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(ChangeColorsBiomeModifier::grassColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(ChangeColorsBiomeModifier::foliageColor)).apply((Applicative)instance, ChangeColorsBiomeModifier::new));

    public ChangeColorsBiomeModifier(HolderSet<Biome> biomes, int fogColor, int waterColor, int waterFogColor, int skyColor, int grassColor, int foliageColor) {
        this(biomes, Optional.of(fogColor), Optional.of(waterColor), Optional.of(waterFogColor), Optional.of(skyColor), Optional.of(grassColor), Optional.of(foliageColor));
    }

    public ChangeColorsBiomeModifier(HolderSet<Biome> biomes, int fogColor, int waterColor, int waterFogColor, int skyColor, int foliageColor) {
        this(biomes, Optional.of(fogColor), Optional.of(waterColor), Optional.of(waterFogColor), Optional.of(skyColor), Optional.empty(), Optional.of(foliageColor));
    }

    public ChangeColorsBiomeModifier(HolderSet<Biome> biomes, int fogColor, int waterColor, int waterFogColor, int skyColor) {
        this(biomes, Optional.of(fogColor), Optional.of(waterColor), Optional.of(waterFogColor), Optional.of(skyColor), Optional.empty(), Optional.empty());
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.BEFORE_EVERYTHING && this.biomes.contains(biome)) {
            BiomeSpecialEffectsBuilder effectsBuilder = builder.getSpecialEffects();
            this.fogColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effectsBuilder).fogColor(arg_0));
            this.waterColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effectsBuilder).waterColor(arg_0));
            this.waterFogColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effectsBuilder).waterFogColor(arg_0));
            this.skyColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effectsBuilder).skyColor(arg_0));
            if (effectsBuilder.getGrassColorModifier() == BiomeSpecialEffects.GrassColorModifier.NONE) {
                this.grassColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effectsBuilder).grassColorOverride(arg_0));
            }
            this.foliageColor.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)effectsBuilder).foliageColorOverride(arg_0));
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

