/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.block.FrostedGrassBlock;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.moulberry.mixinconstraints.annotations.IfModAbsent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@IfModAbsent(value="snowrealmagic")
@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Shadow
    public abstract ServerLevel getLevel();

    @Inject(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", ordinal=2, shift=At.Shift.BEFORE)}, cancellable=true)
    private void nml$tickPrecipitation(BlockPos pos, CallbackInfo ci) {
        ServerLevel level = this.getLevel();
        BlockState state = level.getBlockState(pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos));
        if (state.is(Blocks.SHORT_GRASS) || state.is((Block)NMLBlocks.FROSTED_GRASS.get())) {
            level.setBlockAndUpdate(pos, (BlockState)((FrostedGrassBlock)((Object)NMLBlocks.FROSTED_GRASS.get())).defaultBlockState().setValue((Property)FrostedGrassBlock.SNOWLOGGED, (Comparable)Boolean.valueOf(true)));
            BlockPos posBelow = pos.below();
            BlockState stateUnder = level.getBlockState(posBelow);
            if (stateUnder.getBlock() instanceof SnowyDirtBlock) {
                level.setBlockAndUpdate(posBelow, (BlockState)stateUnder.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)));
            }
            ci.cancel();
        }
    }
}

