/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.registry.NMLTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FlowerBlock.class})
public class FlowerBlockMixin
implements BonemealableBlock {
    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return blockState.is(NMLTags.BONEMEALABLE_FLOWERS);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        for (BlockPos pos : BlockPos.betweenClosed((int)(x - 3), (int)(y - 1), (int)(z - 3), (int)(x + 3), (int)(y + 2), (int)(z + 3))) {
            if (!(randomSource.nextFloat() < 0.3f) || !blockState.canSurvive((LevelReader)serverLevel, pos) || !serverLevel.isEmptyBlock(pos)) continue;
            serverLevel.setBlockAndUpdate(pos, blockState);
        }
    }
}

