/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.item;

import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public abstract class ThrowableBombItem
extends Item
implements ProjectileItem {
    protected static final int DEFAULT_THROW_TIME = 10;
    private static final int COOLDOWN_TIME = 40;

    public ThrowableBombItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 7200;
    }

    public UseAnim getUseAnimation(ItemStack arg) {
        return UseAnim.BOW;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        int timeUsed = this.getUseDuration(stack, entity) - remainingTicks;
        if (timeUsed >= 10 && !entity.isShiftKeyDown()) {
            entity.releaseUsingItem();
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int remainingTicks) {
        Player player;
        if (this.getUseDuration(stack, entity) - remainingTicks < 10) {
            return;
        }
        if (!level.isClientSide()) {
            ThrowableBombEntity bomb = this.asProjectile(level, (Position)entity.getEyePosition(), stack, entity.getNearestViewDirection());
            bomb.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, 0.8f, 1.0f);
            level.addFreshEntity((Entity)bomb);
        }
        level.playSound(entity instanceof Player ? (player = (Player)entity) : null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f));
        if (!(entity instanceof Player) || !(player = (Player)entity).isCreative()) {
            stack.shrink(1);
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown(stack.getItem(), 40);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().power(ProjectileItem.DispenseConfig.DEFAULT.power() * 0.5f).build();
    }

    public abstract ThrowableBombEntity asProjectile(Level var1, Position var2, ItemStack var3, Direction var4);
}

