/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.tortoise.ai;

import com.farcr.nomansland.common.entity.tortoise.Tortoise;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class TortoiseStayAroundHomeGoal
extends Goal {
    private final Tortoise tortoise;
    private final double speedModifier;
    private boolean stuck;
    private int closeToHomeTryTicks;

    public TortoiseStayAroundHomeGoal(Tortoise tortoise, double speedModifier) {
        this.tortoise = tortoise;
        this.speedModifier = speedModifier;
    }

    public boolean canUse() {
        return this.tortoise.getHomePos() != null && !this.tortoise.getHomePos().closerToCenterThan((Position)this.tortoise.position(), 10.0) && !this.tortoise.inShell();
    }

    public void start() {
        this.tortoise.setGoingHome(true);
    }

    public void tick() {
        BlockPos blockpos = this.tortoise.getHomePos();
        if (blockpos == null) {
            return;
        }
        if (this.tortoise.getNavigation().isDone()) {
            Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockpos);
            if (vec3 == null) {
                this.stuck = true;
                return;
            }
            this.tortoise.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, this.speedModifier);
        }
    }

    public void stop() {
        this.tortoise.setGoingHome(false);
    }

    public boolean canContinueToUse() {
        return this.tortoise.getHomePos() != null && !this.tortoise.getHomePos().closerToCenterThan((Position)this.tortoise.position(), 10.0);
    }
}

