/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.moose;

import com.farcr.nomansland.common.entity.moose.MooseAI;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Moose
extends PathfinderMob
implements PlayerRideable,
Saddleable {
    private static final EntityDataAccessor<Boolean> DATA_HAS_ANTLERS = SynchedEntityData.defineId(Moose.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_SADDLED = SynchedEntityData.defineId(Moose.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int pacificationStage;

    public Moose(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createLivingAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HAS_ANTLERS, (Object)true);
        builder.define(DATA_IS_SADDLED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("PacificationStage", this.getPacificationStage());
        compound.putBoolean("HasAntlers", this.hasAntlers());
        compound.putBoolean("IsSaddled", this.isSaddled());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setPacificationStage(compound.getInt("PacificationStage"));
        this.setHasAntlers(compound.getBoolean("HasAntlers"));
        this.setIsSaddled(compound.getBoolean("IsSaddled"));
    }

    protected Brain.Provider<Moose> brainProvider() {
        return MooseAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return MooseAI.makeBrain((Brain<Moose>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Moose> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("mooseBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("mooseActivityUpdate");
        MooseAI.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Items.SADDLE) && !this.isBaby() && !this.isSaddled()) {
            if (!this.level().isClientSide) {
                this.equipSaddle(stack, SoundSource.NEUTRAL);
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isPacified()) {
            if (this.isSaddled() && !this.isVehicle()) {
                this.doPlayerRide(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        } else if (this.getTarget() == null && stack.is(Items.GOLDEN_CARROT)) {
            if (!this.level().isClientSide) {
                int stage = this.getPacificationStage();
                stack.shrink(1);
                if (stage < 4) {
                    this.setPacificationStage(stage + 1);
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                } else if (this.random.nextInt(3) == 0) {
                    this.setPacificationStage(5);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.brain.getMemory(MemoryModuleType.ANGRY_AT).ifPresent(target -> {
                        if (player.getUUID().equals(target)) {
                            this.brain.eraseMemory(MemoryModuleType.ANGRY_AT);
                        }
                    });
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    protected void doPlayerRide(Player player) {
        if (!this.level().isClientSide) {
            player.setYRot(this.getYRot());
            player.setXRot(this.getXRot());
            player.startRiding((Entity)this);
        }
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.getXRot() * 0.5f, entity.getYRot());
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVector) {
        float x = player.xxa * 0.5f;
        float z = player.zza;
        if (z <= 0.0f) {
            z *= 0.25f;
        }
        return new Vec3((double)x, 0.0, (double)z);
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 direction, LivingEntity passenger) {
        double x = this.getX() + direction.x;
        double y = this.getBoundingBox().minY;
        double z = this.getZ() + direction.z;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : passenger.getDismountPoses()) {
            mutablePos.set(x, y, z);
            double d3 = this.getBoundingBox().maxY + 0.75;
            do {
                double d4 = this.level().getBlockFloorHeight((BlockPos)mutablePos);
                if ((double)mutablePos.getY() + d4 > d3) continue block0;
                if (DismountHelper.isBlockFloorValid((double)d4)) {
                    AABB aabb = passenger.getLocalBoundsForPose(pose);
                    Vec3 vec3 = new Vec3(x, (double)mutablePos.getY() + d4, z);
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)aabb.move(vec3))) {
                        passenger.setPose(pose);
                        return vec3;
                    }
                }
                mutablePos.move(Direction.UP);
            } while (!((double)mutablePos.getY() < d3));
        }
        return null;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Vec3 escapeVector = Moose.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(this.getYRot() + (livingEntity.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 dismountLocation = this.getDismountLocationInDirection(escapeVector, livingEntity);
        if (dismountLocation != null) {
            return dismountLocation;
        }
        escapeVector = Moose.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(this.getYRot() + (livingEntity.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        dismountLocation = this.getDismountLocationInDirection(escapeVector, livingEntity);
        return dismountLocation != null ? dismountLocation : this.position();
    }

    public void handleEntityEvent(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!tamed) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player) {
            return (Player)entity;
        }
        return super.getControllingPassenger();
    }

    public boolean doHurtTarget(Entity entity) {
        double power = this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        double damage = power > 0.0 ? power / 2.0 + (double)this.random.nextInt((int)power) : power;
        DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
        boolean hurt = entity.hurt(damagesource, (float)damage);
        if (hurt) {
            double knockbackResistance;
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                knockbackResistance = livingentity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            } else {
                knockbackResistance = 0.0;
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)0.4f * Math.max(0.0, 1.0 - knockbackResistance), 0.0));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damagesource);
            }
        }
        return hurt;
    }

    public int getPacificationStage() {
        return this.pacificationStage;
    }

    public void setPacificationStage(int stage) {
        this.pacificationStage = stage;
    }

    public boolean isPacified() {
        return this.getPacificationStage() == 5;
    }

    public boolean hasAntlers() {
        return (Boolean)this.entityData.get(DATA_HAS_ANTLERS);
    }

    public void setHasAntlers(boolean hasAntlers) {
        this.entityData.set(DATA_HAS_ANTLERS, (Object)hasAntlers);
    }

    public boolean isSaddleable() {
        return this.isPacified();
    }

    public void equipSaddle(ItemStack itemStack, @Nullable SoundSource soundSource) {
        this.setIsSaddled(true);
    }

    public void shakeOffSaddle() {
        this.setIsSaddled(false);
        ItemEntity itementity = this.spawnAtLocation((ItemLike)Items.SADDLE, 1);
        if (itementity != null) {
            itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(DATA_IS_SADDLED);
    }

    public void setIsSaddled(boolean isSaddled) {
        this.entityData.set(DATA_IS_SADDLED, (Object)isSaddled);
    }
}

