/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.bombs;

import com.farcr.nomansland.common.entity.PacifiedCloud;
import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.entities.NMLEffects;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.items.NMLItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class LivingUrn
extends ThrowableBombEntity {
    private static final float VERTICAL_RESTITUTION = 0.3f;
    private static final float HORIZONTAL_RESTITUTION = 0.4f;
    private int bounceCooldown = -1;
    private float shakeTimer = 0.0f;

    public LivingUrn(EntityType<? extends ThrowableBombEntity> entityType, Level level) {
        super(entityType, level);
    }

    public LivingUrn(LivingEntity livingEntity, Level level) {
        super(NMLEntities.LIVING_URN.get(), livingEntity, level);
    }

    public LivingUrn(Level level, double x, double y, double z) {
        super(NMLEntities.LIVING_URN.get(), x, y, z, level);
    }

    private void spawnParticles(ParticleOptions particle, int amount) {
        for (int i = 0; i < amount; ++i) {
            double theta = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
            double alpha = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
            double cos = Math.cos(alpha);
            double xVelocity = Math.sin(theta) * cos * ((double)this.random.nextFloat() * 0.3 + 0.7);
            double yVelocity = cos * Math.cos(theta) * ((double)this.random.nextFloat() * 0.3 + 0.7);
            double zVelocity = Math.sin(alpha) * ((double)this.random.nextFloat() * 0.3 + 0.7);
            this.level().addParticle(particle, this.getX(), this.getY(), this.getZ(), xVelocity * 0.6, yVelocity * 0.6, zVelocity * 0.6);
        }
    }

    public void handleEntityEvent(byte b) {
        if (b == 0) {
            this.spawnParticles((ParticleOptions)ParticleTypes.SMOKE, 320);
            for (int i = 0; i < 40; ++i) {
                double theta = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double alpha = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double cos = Math.cos(alpha);
                double xVelocity = Math.sin(theta) * cos * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double yVelocity = cos * Math.cos(theta) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double zVelocity = Math.sin(alpha) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, false, this.getX(), this.getY(), this.getZ(), xVelocity * 0.1, yVelocity * 0.1, zVelocity * 0.1);
            }
        } else if (b == 1) {
            this.spawnParticles((ParticleOptions)ParticleTypes.SMOKE, 400);
        } else {
            super.handleEntityEvent(b);
        }
    }

    @Override
    protected void explode() {
        PacifiedCloud pacifiedCloud = new PacifiedCloud(this.level(), this.getX(), this.getY() - 1.0, this.getZ());
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)owner;
            pacifiedCloud.setOwner(livingentity);
        }
        pacifiedCloud.setRadius(2.5f);
        pacifiedCloud.setWaitTime(0);
        pacifiedCloud.setDuration(120);
        pacifiedCloud.setRadiusPerTick(-0.01f);
        pacifiedCloud.setPotionContents(new PotionContents(Optional.empty(), Optional.of(1), List.of(new MobEffectInstance(NMLEffects.PACIFIED, 1200, 0, false, false))));
        this.level().addFreshEntity((Entity)pacifiedCloud);
        this.level().playSound(null, this.blockPosition(), (SoundEvent)NMLSounds.LIVING_URN_SHATTERS.get(), SoundSource.PLAYERS, 1.0f, 0.75f);
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Vec3 motion = this.getDeltaMovement();
        if (motion.lengthSqr() < 0.1) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setOnGround(true);
            if (motion.x != 0.0 && motion.z != 0.0) {
                this.bounceCooldown = 60;
                this.shakeTimer = 1.0f;
            }
            return;
        }
        Direction direction = result.getDirection();
        switch (direction.getAxis()) {
            case X: {
                this.setDeltaMovement(-motion.x() * (double)0.4f, motion.y(), motion.z());
                break;
            }
            case Y: {
                this.setDeltaMovement(motion.x() * (double)0.3f, -motion.y() * (double)0.3f, motion.z() * (double)0.3f);
                break;
            }
            case Z: {
                this.setDeltaMovement(motion.x(), motion.y(), -motion.z() * (double)0.4f);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide() && result.getEntity() instanceof Monster && !(result.getEntity() instanceof NeutralMob)) {
            this.explode();
        } else {
            Vec3 motion = this.getDeltaMovement();
            Vec3 normal = this.position().subtract(result.getEntity().position()).normalize();
            double dot = motion.dot(normal);
            Vec3 reflected = motion.subtract(normal.scale(2.0 * dot));
            Vec3 bounced = reflected.scale((double)0.4f);
            this.setDeltaMovement(bounced);
        }
    }

    @Override
    protected void updateRotation() {
        if (this.bounceCooldown > 0) {
            return;
        }
        super.updateRotation();
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        Monster monster = (Monster)level.getNearestEntity(Monster.class, TargetingConditions.DEFAULT.range(8.0), null, this.getX(), this.getY(), this.getZ(), new AABB(this.blockPosition()).inflate(8.0));
        if (level.isClientSide()) {
            if (!this.onGround()) {
                level.addParticle(this.getParticle((LevelAccessor)level), this.getX(), this.getY() + (double)this.getBbHeight(), this.getZ(), 0.0, 0.0, 0.0);
            }
            if (this.shakeTimer > 0.0f) {
                if (monster != null && !(monster instanceof NeutralMob) && !monster.hasEffect(NMLEffects.PACIFIED) && this.bounceCooldown > 0) {
                    Vec3 toTarget;
                    if (this.bounceCooldown < 45 && (toTarget = monster.position().subtract(this.position())).lengthSqr() > 0.001) {
                        double dx = toTarget.x;
                        double dz = toTarget.z;
                        float targetYaw = (float)(Mth.atan2((double)(-dx), (double)(-dz)) * 57.29577951308232) + 90.0f;
                        float currentYaw = this.getYRot();
                        float newYaw = Mth.approachDegrees((float)currentYaw, (float)targetYaw, (float)5.0f);
                        if (Math.abs(Mth.degreesDifference((float)currentYaw, (float)targetYaw)) > 1.0f) {
                            this.setYRot(newYaw);
                        }
                    }
                    if (this.bounceCooldown < 15) {
                        this.shakeTimer += 1.0f;
                        float amplitude = Math.min(12.0f, this.shakeTimer * 0.8f);
                        this.roll += (float)(Math.sin(this.shakeTimer) * (double)amplitude);
                    }
                }
                float delta = -this.normalizeAngle(this.roll);
                this.roll += delta * 0.075f;
            } else {
                double motionLen = this.getDeltaMovement().lengthSqr();
                if (motionLen > 0.01) {
                    this.roll = (float)((double)this.roll + Math.sqrt(motionLen) * 45.0);
                }
            }
        }
        if (this.bounceCooldown > 0) {
            --this.bounceCooldown;
            if (this.bounceCooldown == 0) {
                if (monster != null && !(monster instanceof NeutralMob) && !monster.hasEffect(NMLEffects.PACIFIED)) {
                    Vec3 toTarget = monster.position().subtract(this.position());
                    double distance = toTarget.length();
                    if (distance > 0.01) {
                        Vec3 direction = toTarget.normalize();
                        double minSpeed = 0.1;
                        double maxSpeed = 0.4;
                        double minJump = 0.05;
                        double maxJump = 0.5;
                        double clampedDistance = Math.min(8.0, distance);
                        double speed = minSpeed + (maxSpeed - minSpeed) * clampedDistance / 8.0;
                        double jumpStrength = minJump + (maxJump - minJump) * clampedDistance / 8.0;
                        Vec3 jumpImpulse = new Vec3(direction.x * speed, jumpStrength, direction.z * speed);
                        float targetYaw = (float)(Mth.atan2((double)(-toTarget.x), (double)(-toTarget.z)) * 57.29577951308232) + 90.0f;
                        this.setYRot(targetYaw);
                        this.setDeltaMovement(jumpImpulse);
                        this.setOnGround(false);
                        this.bounceCooldown = -1;
                    }
                } else {
                    level.playSound(null, this.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.75f);
                    if (!level.isClientSide) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 10, 0.0, 0.0, 0.0, 0.02);
                    }
                    level.addFreshEntity((Entity)new ItemEntity(level, this.getX(), this.getY(), this.getZ(), NMLItems.LIVING_URN.stack()));
                    this.discard();
                }
            }
        }
    }

    @Override
    protected ParticleOptions getParticle(LevelAccessor levelAccessor) {
        return switch (levelAccessor.getRandom().nextInt(6)) {
            case 0 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)13041538));
            case 1 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)16768386));
            case 2 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)16692156));
            case 3 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)16679679));
            case 4 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)14058239));
            default -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)8585152));
        };
    }

    private float normalizeAngle(float angle) {
        if ((angle %= 360.0f) > 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }
}

