/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.registry.NMLParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownOilBottle
extends ThrownPotion {
    public ThrownOilBottle(Level level, double x, double y, double z) {
        super(level, x, y, z);
    }

    public ThrownOilBottle(Level level, LivingEntity shooter) {
        super(level, shooter);
    }

    protected void onHit(HitResult result) {
        HitResult.Type hitresult$type = result.getType();
        if (hitresult$type == HitResult.Type.ENTITY) {
            EntityHitResult entityhitresult = (EntityHitResult)result;
            Entity entity = entityhitresult.getEntity();
            if (entity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                projectile.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity(entityhitresult);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, result.getLocation(), GameEvent.Context.of((Entity)this, null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)result;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.getBlockPos();
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
        }
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            PotionContents potioncontents = (PotionContents)itemstack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            if (potioncontents.hasEffects()) {
                if (this.isLingering()) {
                    this.makeAreaOfEffectCloud(potioncontents);
                } else {
                    this.applySplash(potioncontents.getAllEffects(), result.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)result).getEntity() : null);
                }
            }
            ServerLevel serverLevel = (ServerLevel)this.level();
            Vec3 vec3 = this.position();
            for (int j = 0; j < 8; ++j) {
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.SPLASH_POTION)), vec3.x, vec3.y, vec3.z, 0, this.random.nextGaussian() * 0.15, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.15, 1.0);
            }
            ParticleOptions particleoptions = (ParticleOptions)NMLParticleTypes.OIL_SPLASH.get();
            for (int i2 = 0; i2 < 200; ++i2) {
                double d10 = this.random.nextDouble() * 4.0;
                double d15 = this.random.nextDouble() * Math.PI * 2.0;
                double d20 = Math.cos(d15) * d10;
                double d24 = 0.01 + this.random.nextDouble() * 0.5;
                double d25 = Math.sin(d15) * d10;
                serverLevel.sendParticles(particleoptions, vec3.x + d20 * 0.1, vec3.y + 0.3, vec3.z + d25 * 0.1, 0, d20, d24, d25, 1.0);
            }
            serverLevel.playSound(null, this.blockPosition(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, this.random.nextFloat() * 0.1f + 0.9f);
            this.discard();
        }
    }
}

