/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.client.particle.TranslucentDustParticleOptions;
import com.farcr.nomansland.common.entity.LingeringCloud;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class PacifiedCloud
extends LingeringCloud {
    public PacifiedCloud(EntityType<? extends LingeringCloud> entityType, Level level) {
        super(entityType, level);
    }

    public PacifiedCloud(Level level, double x, double y, double z) {
        super(NMLEntities.PACIFIED_CLOUD.get(), level);
        this.setPos(x, y, z);
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.getBlockState(this.blockPosition().above((int)((double)this.getBbHeight() * 0.3))).isAir()) {
            Vec3 motion = this.getDeltaMovement();
            double dy = Mth.clamp((double)(motion.y - 0.02), (double)-0.04, (double)0.0);
            this.setDeltaMovement(motion.x, dy, motion.z);
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
    }

    @Override
    public ParticleOptions getParticle(LevelAccessor levelAccessor) {
        return switch (levelAccessor.getRandom().nextInt(6)) {
            case 0 -> TranslucentDustParticleOptions.create(FastColor.ARGB32.color((int)51, (int)13041538));
            case 1 -> TranslucentDustParticleOptions.create(FastColor.ARGB32.color((int)51, (int)16768386));
            case 2 -> TranslucentDustParticleOptions.create(FastColor.ARGB32.color((int)51, (int)16692156));
            case 3 -> TranslucentDustParticleOptions.create(FastColor.ARGB32.color((int)51, (int)16679679));
            case 4 -> TranslucentDustParticleOptions.create(FastColor.ARGB32.color((int)51, (int)14058239));
            default -> TranslucentDustParticleOptions.create(FastColor.ARGB32.color((int)51, (int)8585152));
        };
    }
}

