/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.registry.entities.NMLEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.Vec3;

public class Ember
extends Entity
implements TraceableEntity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public Ember(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public Ember(Level level, double x, double y, double z) {
        super(NMLEntities.EMBER.get(), level);
        this.setPos(x, y, z);
        this.setNoGravity(false);
    }

    public void tick() {
        super.tick();
        if (!this.onGround()) {
            Vec3 motion = this.getDeltaMovement();
            double dy = Mth.clamp((double)(motion.y - 0.02), (double)-0.15, (double)0.0);
            this.setDeltaMovement(motion.x, dy, motion.z);
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        if (this.level().isClientSide && this.level().random.nextFloat() < 0.8f) {
            this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getX(), this.getY(), this.getZ(), (this.random.nextDouble() - 0.5) * 0.02, 0.02 + this.random.nextDouble() * 0.02, (this.random.nextDouble() - 0.5) * 0.02);
        }
        if (this.onGround() && !this.level().isClientSide) {
            BlockPos pos = this.blockPosition();
            if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)pos, (Direction)Direction.UP)) {
                this.level().setBlockAndUpdate(pos, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)pos));
            }
            this.discard();
        }
    }

    protected double getDefaultGravity() {
        return 0.15;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.tickCount = compound.getInt("Age");
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Age", this.tickCount);
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
    }
}

