/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.definitions;

import com.farcr.nomansland.common.definitions.BlockDefinition;
import com.farcr.nomansland.datagen.loot.BlockLootType;
import com.farcr.nomansland.datagen.loot.BookshelfBlockLootType;
import com.farcr.nomansland.datagen.loot.CandleCakeBlockLootType;
import com.farcr.nomansland.datagen.loot.CustomBlockLootType;
import com.farcr.nomansland.datagen.loot.DoorBlockLootType;
import com.farcr.nomansland.datagen.loot.FlowerPotBlockLootType;
import com.farcr.nomansland.datagen.loot.OtherBlockLootType;
import com.farcr.nomansland.datagen.loot.SelfBlockLootType;
import com.farcr.nomansland.datagen.loot.ShearsBlockLootType;
import com.farcr.nomansland.datagen.loot.SlabBlockLootType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record BlockProperties(BlockLootType lootType, boolean customLang) {
    public static BlockProperties custom(boolean customLang) {
        return new BlockProperties(new CustomBlockLootType(), customLang);
    }

    public static BlockProperties simplePath(Block block) {
        return new BlockProperties(new OtherBlockLootType(() -> block), false);
    }

    public static BlockProperties simplePath(BlockDefinition<?> block) {
        return new BlockProperties(new OtherBlockLootType(() -> block.get()), false);
    }

    public static BlockProperties path() {
        return new BlockProperties(new CustomBlockLootType(), false);
    }

    public static BlockProperties fishBarrel() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties dirtLike() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties cauldron() {
        return new BlockProperties(new OtherBlockLootType(() -> Blocks.CAULDRON), true);
    }

    public static BlockProperties icicles() {
        return new BlockProperties(new CustomBlockLootType(), false);
    }

    public static BlockProperties smallFlower() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties flowerbed() {
        return new BlockProperties(new ShearsBlockLootType(), false);
    }

    public static BlockProperties sapling() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties flowerPot(BlockDefinition<?> plant) {
        return new BlockProperties(new FlowerPotBlockLootType(() -> plant.get()), false);
    }

    public static BlockProperties candleCake(Block candle) {
        return new BlockProperties(new CandleCakeBlockLootType(candle), false);
    }

    public static BlockProperties stoneLike() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties stoneLikeStairs() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties stoneLikeSlab() {
        return new BlockProperties(new SlabBlockLootType(), false);
    }

    public static BlockProperties stoneLikeWall() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties log() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties planks() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties woodenButton(BlockDefinition<?> planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties woodenDoor(BlockDefinition<?> planks) {
        return new BlockProperties(new DoorBlockLootType(), false);
    }

    public static BlockProperties woodenFence(BlockDefinition<?> planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties fenceGate(BlockDefinition<?> planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties woodenPressurePlate(BlockDefinition<?> planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties woodenSlab(BlockDefinition<?> planks) {
        return new BlockProperties(new SlabBlockLootType(), false);
    }

    public static BlockProperties woodenStairs(BlockDefinition<?> planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties woodenTrapdoor(BlockDefinition<?> planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties bookshelf(BlockDefinition<?> planks) {
        return new BlockProperties(new BookshelfBlockLootType(), false);
    }

    public static BlockProperties bookshelf(Block planks) {
        return new BlockProperties(new BookshelfBlockLootType(), false);
    }

    public static BlockProperties trimmedPlanks(BlockDefinition<?> planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties trimmedPlanks(Block planks) {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties sign() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }

    public static BlockProperties hangingSign() {
        return new BlockProperties(new SelfBlockLootType(), false);
    }
}

