/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.tap;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.block.tap.TapInteraction;
import com.farcr.nomansland.common.blockentity.TapBlockEntity;
import com.farcr.nomansland.common.registry.NMLBlockEntities;
import com.farcr.nomansland.common.registry.NMLRegistries;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TapBlock
extends BaseEntityBlock {
    public static final MapCodec<TapBlock> CODEC = TapBlock.simpleCodec(TapBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)6.0, (double)3.0, (double)10.0, (double)10.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)8.0, (double)6.0), (Object)Direction.WEST, (Object)Block.box((double)10.0, (double)3.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)6.0, (double)6.0, (double)8.0, (double)10.0)));

    public TapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static VoxelShape getShape(BlockState state) {
        return AABBS.get(state.getValue((Property)FACING));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public static BlockState getBlockStateBehind(Level level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
    }

    public static BlockPos getCauldronPos(Level level, BlockPos tapPos) {
        for (int i = 0; i <= 3; ++i) {
            BlockPos posBelow = tapPos.below(i);
            BlockState stateBelow = level.getBlockState(posBelow);
            if (stateBelow.getBlock() instanceof AbstractCauldronBlock) {
                return posBelow;
            }
            if (!stateBelow.isCollisionShapeFullBlock((BlockGetter)level, posBelow)) continue;
            return null;
        }
        return null;
    }

    public static void spawnDrippingParticles(Level level, BlockPos pos, BlockState state, SimpleParticleType particleType) {
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                x = (double)pos.getX() + 0.5;
                y = (double)((float)(pos.getY() + 1) - 0.75f) - 0.09;
                z = (double)pos.getZ() + 0.68;
                break;
            }
            case SOUTH: {
                x = (double)pos.getX() + 0.5;
                y = (double)((float)(pos.getY() + 1) - 0.75f) - 0.09;
                z = (double)pos.getZ() + 0.32;
                break;
            }
            case EAST: {
                x = (double)pos.getX() + 0.32;
                y = (double)((float)(pos.getY() + 1) - 0.75f) - 0.09;
                z = (double)pos.getZ() + 0.5;
                break;
            }
            case WEST: {
                x = (double)pos.getX() + 0.68;
                y = (double)((float)(pos.getY() + 1) - 0.75f) - 0.09;
                z = (double)pos.getZ() + 0.5;
            }
        }
        if (level.isClientSide) {
            level.addParticle((ParticleOptions)particleType, x, y, z, 0.0, 0.0, 0.0);
        } else {
            ((ServerLevel)level).sendParticles((ParticleOptions)particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : adirection = context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return TapBlock.getShape(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBehind;
        BlockPos posBehind;
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        return MultifaceBlock.canAttachTo((BlockGetter)level, (Direction)direction, (BlockPos)(posBehind = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())), (BlockState)(stateBehind = level.getBlockState(posBehind))) || stateBehind.getBlock() instanceof AbstractCauldronBlock;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos cauldronPos = TapBlock.getCauldronPos((Level)level, pos);
        if (cauldronPos == null) {
            return;
        }
        BlockState cauldronState = level.getBlockState(cauldronPos);
        BlockState stateBehind = TapBlock.getBlockStateBehind((Level)level, pos, state);
        List<Holder.Reference> allTapInteractions = level.registryAccess().registryOrThrow(NMLRegistries.TAP_INTERACTION_KEY).holders().filter(tapInteractionReference -> ((TapInteraction)tapInteractionReference.value()).particleType().isPresent()).toList();
        for (Holder.Reference tapInteractionReference2 : allTapInteractions) {
            boolean hasBlock = false;
            for (BlockStateProvider blockStateProvider : ((TapInteraction)tapInteractionReference2.value()).sources()) {
                BlockState neededState = blockStateProvider.getState(level.random, pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
                if (stateBehind != neededState) continue;
                if (neededState.is(BlockTags.LOGS)) {
                    if (stateBehind != TapBlock.getBlockStateBehind((Level)level, pos.above(), state) || stateBehind != TapBlock.getBlockStateBehind((Level)level, pos.below(), state)) break;
                    hasBlock = true;
                    break;
                }
                hasBlock = true;
                break;
            }
            if (!hasBlock || !(random.nextFloat() < 0.05f * ((TapInteraction)tapInteractionReference2.value()).rate())) continue;
            TapBlock.tryFill(cauldronState, cauldronPos, (Level)level, (TapInteraction)tapInteractionReference2.value());
            break;
        }
    }

    public static void tryFill(BlockState cauldronState, BlockPos cauldronPos, Level level, TapInteraction tapInteraction) {
        AbstractCauldronBlock cauldron;
        Block block;
        if (cauldronState.getBlock() == tapInteraction.cauldron() && (block = cauldronState.getBlock()) instanceof AbstractCauldronBlock && !(cauldron = (AbstractCauldronBlock)block).isFull(cauldronState)) {
            BlockState newState = cauldronState.getBlock() instanceof FourLayeredCauldronBlock ? (BlockState)cauldronState.setValue((Property)FourLayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)cauldronState.getValue((Property)FourLayeredCauldronBlock.LEVEL) + 1)) : (BlockState)cauldronState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)cauldronState.getValue((Property)LayeredCauldronBlock.LEVEL) + 1));
            level.setBlockAndUpdate(cauldronPos, newState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, cauldronPos, GameEvent.Context.of((BlockState)newState));
        } else if (cauldronState.is(Blocks.CAULDRON)) {
            level.setBlockAndUpdate(cauldronPos, tapInteraction.cauldron().defaultBlockState());
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, cauldronPos, GameEvent.Context.of((BlockState)tapInteraction.cauldron().defaultBlockState()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        List<Holder.Reference> allTapInteractions = level.registryAccess().registryOrThrow(NMLRegistries.TAP_INTERACTION_KEY).holders().filter(tapInteractionReference -> ((TapInteraction)tapInteractionReference.value()).particleType().isPresent()).toList();
        BlockState stateBehind = TapBlock.getBlockStateBehind(level, pos, state);
        for (Holder.Reference tapInteractionReference2 : allTapInteractions) {
            boolean hasBlock = false;
            for (BlockStateProvider blockStateProvider : ((TapInteraction)tapInteractionReference2.value()).sources()) {
                BlockState neededState = blockStateProvider.getState(level.random, pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
                if (stateBehind != neededState) continue;
                if (neededState.is(BlockTags.LOGS)) {
                    if (stateBehind != TapBlock.getBlockStateBehind(level, pos.above(), state) || stateBehind != TapBlock.getBlockStateBehind(level, pos.below(), state)) break;
                    hasBlock = true;
                    break;
                }
                hasBlock = true;
                break;
            }
            if (!hasBlock || !(random.nextFloat() < 0.05f)) continue;
            TapBlock.spawnDrippingParticles(level, pos, state, (SimpleParticleType)((TapInteraction)tapInteractionReference2.value()).particleType().get());
            break;
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TapBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.isClientSide ? null : TapBlock.createTickerHelper(blockEntity, NMLBlockEntities.TAP.get(), TapBlockEntity::tick);
    }
}

