/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.cauldrons;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.integration.FDIntegration;
import com.farcr.nomansland.common.registry.NMLSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WitchStewCauldron
extends FourLayeredCauldronBlock {
    public WitchStewCauldron() {
        super(null);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d0 = (double)pos.getX() + 0.5 + (double)random.nextInt(-40, 40) * 0.01;
        double d1 = (double)pos.getY() + (double)random.nextInt(-10, 40) * 0.001 + this.getContentHeight(state);
        double d2 = (double)pos.getZ() + 0.5 + (double)random.nextInt(-40, 40) * 0.01;
        Particle particle = Minecraft.getInstance().levelRenderer.addParticleInternal((ParticleOptions)ParticleTypes.EFFECT, ParticleTypes.EFFECT.getOverrideLimiter(), d0, d1, d2, 0.0, 0.0, 0.0);
        if (particle != null) {
            float f1 = 0.75f + random.nextFloat() * 0.25f;
            particle.setColor(0.5294118f * f1, 0.6392157f * f1, 0.3882353f * f1);
            particle.setPower(random.nextFloat() * 4.0f);
        }
        if (random.nextInt(15) == 0) {
            level.playLocalSound(d0, d1, d2, (SoundEvent)NMLSounds.WITCH_STEW_CAULDRON_AMBIENT.get(), SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.2f + 0.9f, false);
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.BOWL)) {
            ItemStack item;
            stack.consume(1, (LivingEntity)player);
            if (!(player.isCreative() && player.getInventory().hasAnyMatching(s -> s.getItem() == FDIntegration.WITCH_STEW_ITEM.item()) || player.addItem(item = new ItemStack((ItemLike)FDIntegration.WITCH_STEW_ITEM.item())))) {
                player.drop(item, false);
            }
            level.playSound(null, pos, (SoundEvent)NMLSounds.WITCH_STEW_CAULDRON_EMPTY.value(), SoundSource.BLOCKS);
            if ((Integer)state.getValue((Property)LEVEL) > 1) {
                WitchStewCauldron.lowerFillLevel(state, level, pos);
            } else {
                level.setBlockAndUpdate(pos, FDIntegration.EMPTY_WITCH_STEW.block().defaultBlockState());
            }
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.isFull(state) ? FDIntegration.WITCH_STEW_BLOCK_ITEM.stack() : super.getCloneItemStack(state, target, level, pos, player);
    }
}

