/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.neoforge.common.util.TriState;

public class SurfaceMushroomBlock
extends MushroomBlock {
    public SurfaceMushroomBlock(ResourceKey<ConfiguredFeature<?, ?>> pFeature, BlockBehaviour.Properties pProperties) {
        super(pFeature, pProperties);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos lowerPos = pos.below();
        BlockState lowerState = level.getBlockState(lowerPos);
        TriState soilDecision = lowerState.canSustainPlant((BlockGetter)level, lowerPos, Direction.UP, state);
        return lowerState.is(BlockTags.MUSHROOM_GROW_BLOCK) || (soilDecision.isDefault() ? this.mayPlaceOn(lowerState, (BlockGetter)level, lowerPos) : soilDecision.isTrue());
    }
}

