/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.block.CandleFruitCakeBlock;
import com.farcr.nomansland.common.integration.FDIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class FruitCakeBlock
extends CakeBlock {
    public FruitCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Block var10;
        Item item = stack.getItem();
        int bites = (Integer)state.getValue((Property)BITES);
        if (stack.is(ItemTags.CANDLES) && bites == 0 && (var10 = Block.byItem((Item)item)) instanceof CandleBlock) {
            CandleBlock candleBlock = (CandleBlock)var10;
            stack.consume(1, (LivingEntity)player);
            level.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(pos, CandleFruitCakeBlock.byCandle(candleBlock));
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(ModTags.KNIVES)) {
            if (bites < 6) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CakeBlock.BITES, (Comparable)Integer.valueOf(bites + 1)));
            } else {
                level.removeBlock(pos, false);
            }
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)FDIntegration.FRUIT_CAKE_SLICE.get()), (double)((double)pos.getX() + (double)bites * 0.1), (double)((double)pos.getY() + 0.2), (double)((double)pos.getZ() + 0.5), (double)-0.05, (double)0.0, (double)0.0);
            level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

