/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.renderer;

import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;

public abstract class ThrowableBombRenderer<T extends ThrowableBombEntity>
extends EntityRenderer<T> {
    public ThrowableBombRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    private void renderModelLists(BakedModel bakedModel, int packedLight, int packedOverlay, PoseStack poseStack, VertexConsumer vertexConsumer) {
        RandomSource random = RandomSource.create();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.renderQuadList(poseStack, vertexConsumer, bakedModel.getQuads(null, direction, random), packedLight, packedOverlay);
        }
        random.setSeed(42L);
        this.renderQuadList(poseStack, vertexConsumer, bakedModel.getQuads(null, null, random), packedLight, packedOverlay);
    }

    private void renderQuadList(PoseStack matrixStack, VertexConsumer vertexConsumer, List<BakedQuad> quads, int packedLight, int packedOverlay) {
        PoseStack.Pose pose = matrixStack.last();
        for (BakedQuad bakedQuad : quads) {
            vertexConsumer.putBulkData(pose, bakedQuad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffers, int packedLight) {
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(this.getModelLocation(entity));
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((ThrowableBombEntity)((Object)entity)).yRotO, (float)entity.getYRot()) - 90.0f));
        matrixStack.translate(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((ThrowableBombEntity)((Object)entity)).xRotO, (float)entity.getXRot()) - ((ThrowableBombEntity)((Object)entity)).getRoll(partialTicks)));
        matrixStack.translate(0.0f, -entity.getBbHeight() / 2.0f, 0.0f);
        this.scale(entity, matrixStack, partialTicks);
        matrixStack.translate(-0.5, 0.0, -0.5);
        this.renderModelLists(model, packedLight, OverlayTexture.pack((int)OverlayTexture.u((float)this.getWhiteOverlayProgress(entity, partialTicks)), (int)10), matrixStack, buffers.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity))));
        matrixStack.popPose();
        super.render(entity, yaw, partialTicks, matrixStack, buffers, packedLight);
    }

    protected void scale(T entity, PoseStack poseStack, float partialTicks) {
        float f = ((ThrowableBombEntity)((Object)entity)).getSwelling(partialTicks);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.5f) * f1;
        float f3 = (1.0f + f * 0.2f) / f1;
        poseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(T entity, float partialTicks) {
        float f = ((ThrowableBombEntity)((Object)entity)).getSwelling(partialTicks);
        return (int)(f * 5.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.0f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    public abstract ModelResourceLocation getModelLocation(T var1);
}

