/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model.moose;

import com.farcr.nomansland.client.model.utils.AnimUtil;
import com.farcr.nomansland.common.entity.moose.Moose;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class MooseModel<T extends Moose>
extends AgeableHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart upper_body;
    private final ModelPart lower_body;
    private final ModelPart right_back_leg;
    private final ModelPart left_back_leg;
    private final ModelPart tail;
    private final ModelPart right_front_leg;
    private final ModelPart left_front_leg;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart dewlap;
    private final ModelPart left_ear;
    private final ModelPart right_ear;

    public MooseModel(ModelPart root) {
        super(0.5f, 24.0f);
        this.root = root;
        this.upper_body = root.getChild("upper_body");
        this.lower_body = this.upper_body.getChild("lower_body");
        this.right_back_leg = this.lower_body.getChild("right_back_leg");
        this.left_back_leg = this.lower_body.getChild("left_back_leg");
        this.tail = this.lower_body.getChild("tail");
        this.right_front_leg = this.upper_body.getChild("right_front_leg");
        this.left_front_leg = this.upper_body.getChild("left_front_leg");
        this.neck = this.upper_body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.dewlap = this.head.getChild("dewlap");
        this.left_ear = this.head.getChild("left_ear");
        this.right_ear = this.head.getChild("right_ear");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper_body = partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, 0.0f, 0.0f, 14.0f, 18.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)-16.0f));
        PartDefinition lower_body = upper_body.addOrReplaceChild("lower_body", CubeListBuilder.create().texOffs(0, 33).addBox(-6.0f, -15.0f, 0.0f, 12.0f, 15.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)15.0f));
        PartDefinition right_back_leg = lower_body.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(70, 60).addBox(-1.0f, -3.0f, -3.0f, 3.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, 11.0f, -1.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-4.0f, (float)11.0f));
        PartDefinition left_back_leg = lower_body.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0f, 11.0f, -1.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(70, 60).mirror().addBox(-2.0f, -3.0f, -3.0f, 3.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)6.0f, (float)-4.0f, (float)11.0f));
        PartDefinition tail = lower_body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-13.0f, (float)17.0f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(0, 41).addBox(-1.0f, -16.5445f, 14.6003f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-23.0f, (float)-0.829f, (float)0.0f, (float)0.0f));
        PartDefinition right_front_leg = upper_body.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(56, 41).mirror().addBox(-1.0f, -6.0f, -3.0f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(43, 0).addBox(0.0f, 13.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)12.0f, (float)5.0f));
        PartDefinition left_front_leg = upper_body.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(56, 41).addBox(-3.0f, -6.0f, -3.0f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(43, 0).mirror().addBox(-3.0f, 13.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)12.0f, (float)5.0f));
        PartDefinition neck = upper_body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(26, 64).addBox(-3.5f, -2.0f, -4.0f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(58, 0).addBox(-3.5f, -3.0f, -9.0f, 7.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition leftantlerconnection_r1 = head.addOrReplaceChild("leftantlerconnection_r1", CubeListBuilder.create().texOffs(40, 41).addBox(13.9067f, -2.5333f, -15.929f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)14.0f, (float)-0.131f, (float)0.6387f, (float)-0.4171f));
        PartDefinition leftantler_r1 = head.addOrReplaceChild("leftantler_r1", CubeListBuilder.create().texOffs(44, 19).addBox(-11.1894f, -23.2791f, -17.5951f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)14.0f, (float)0.6151f, (float)0.0497f, (float)1.2677f));
        PartDefinition rightantler_r1 = head.addOrReplaceChild("rightantler_r1", CubeListBuilder.create().texOffs(44, 19).mirror().addBox(3.1894f, -23.2791f, -17.5951f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)14.0f, (float)0.6151f, (float)-0.0497f, (float)-1.2677f));
        PartDefinition rightantlerconnection_r1 = head.addOrReplaceChild("rightantlerconnection_r1", CubeListBuilder.create().texOffs(40, 41).mirror().addBox(-17.9067f, -2.5333f, -15.929f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)14.0f, (float)-0.131f, (float)-0.6387f, (float)0.4171f));
        PartDefinition snout_r1 = head.addOrReplaceChild("snout_r1", CubeListBuilder.create().texOffs(0, 64).addBox(-2.0f, -0.0342f, -7.5221f, 5.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-2.0f, (float)-9.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition dewlap = head.addOrReplaceChild("dewlap", CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(52, 66).addBox(-1.0f, 0.0f, 5.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-8.0f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-3.0f, (float)-3.0f));
        PartDefinition leftear_r1 = left_ear.addOrReplaceChild("leftear_r1", CubeListBuilder.create().texOffs(10, 41).addBox(0.1014f, -9.2713f, -18.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)5.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-3.0f, (float)-3.0f));
        PartDefinition rightear_r1 = right_ear.addOrReplaceChild("rightear_r1", CubeListBuilder.create().texOffs(10, 41).mirror().addBox(-2.1014f, -9.2713f, -18.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)5.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(Moose entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float idleTime = ageInTicks * 0.01f;
        float idlePower = 1.0f;
        this.left_ear.zRot += AnimUtil.wave(idleTime) * idlePower * 0.03f;
        this.left_ear.xRot += (AnimUtil.wave(idleTime * 0.5f) / 2.0f + 0.7f) * idlePower * 0.1f;
        this.right_ear.zRot += AnimUtil.wave(idleTime * 0.92f) * idlePower * 0.03f;
        this.right_ear.xRot += (AnimUtil.wave(idleTime * 0.5f + 0.2f) / 2.0f + 0.7f) * idlePower * 0.1f;
        this.dewlap.zRot += AnimUtil.wave(idleTime) * idlePower * 0.03f;
        this.dewlap.xRot += AnimUtil.wave(idleTime * 0.93f) * idlePower * 0.01f;
        this.neck.y += AnimUtil.wave(idleTime) * idlePower * 0.1f;
        this.head.y += AnimUtil.wave(idleTime - 0.2f) * idlePower * 0.05f;
        float bodyYOffset = AnimUtil.wave(idleTime + 0.2f) * idlePower * 0.1f;
        this.upper_body.y += bodyYOffset;
        this.left_front_leg.y -= bodyYOffset;
        this.right_front_leg.y -= bodyYOffset;
        this.left_back_leg.y -= bodyYOffset;
        this.right_back_leg.y -= bodyYOffset;
        this.head.xRot += headPitch * 0.6f * ((float)Math.PI / 180);
        this.head.yRot += netHeadYaw * 0.6f * ((float)Math.PI / 180);
        this.neck.xRot += headPitch * 0.4f * ((float)Math.PI / 180);
        this.neck.yRot += netHeadYaw * 0.4f * ((float)Math.PI / 180);
        this.dewlap.xRot -= Math.min(headPitch * ((float)Math.PI / 180), 0.1f);
        float runWeight = Math.clamp((limbSwingAmount - 0.6f) * 7.0f, 0.0f, 1.0f);
        float walkWeight = 1.0f - runWeight;
        float walkTime = limbSwing * 0.2f;
        float walkPower = Math.min(limbSwingAmount * 3.5f, 0.8f) * walkWeight;
        float bodyYOffset2 = AnimUtil.wave(walkTime * 2.0f) * walkPower * -0.3f;
        this.upper_body.y += bodyYOffset2;
        this.upper_body.z += AnimUtil.wave(walkTime * 2.0f + 0.1f) * walkPower * 0.3f;
        this.left_front_leg.y -= bodyYOffset2;
        this.right_front_leg.y -= bodyYOffset2;
        this.left_back_leg.y -= bodyYOffset2;
        this.right_back_leg.y -= bodyYOffset2;
        this.left_front_leg.xRot += AnimUtil.wave(walkTime + 0.5f - 0.1f) * walkPower * 0.2f;
        this.left_front_leg.y -= Math.max(AnimUtil.wave(walkTime), 0.0f) * walkPower * 4.0f;
        this.left_front_leg.z -= AnimUtil.wave(walkTime + 0.75f) * walkPower * 3.0f;
        this.right_front_leg.xRot += AnimUtil.wave(walkTime - 0.1f) * walkPower * 0.2f;
        this.right_front_leg.y -= Math.max(AnimUtil.wave(walkTime + 0.5f), 0.0f) * walkPower * 4.0f;
        this.right_front_leg.z -= AnimUtil.wave(walkTime + 0.25f) * walkPower * 3.0f;
        this.left_back_leg.xRot += AnimUtil.wave((walkTime += 0.1f) - 0.1f) * walkPower * 0.1f;
        this.left_back_leg.y -= Math.max(AnimUtil.wave(walkTime + 0.5f), 0.0f) * walkPower * 2.0f;
        this.left_back_leg.z -= AnimUtil.wave(walkTime + 0.25f) * walkPower * 3.0f;
        this.right_back_leg.xRot += AnimUtil.wave((walkTime -= 0.1f) + 0.5f - 0.1f) * walkPower * 0.1f;
        this.right_back_leg.y -= Math.max(AnimUtil.wave(walkTime), 0.0f) * walkPower * 2.0f;
        this.right_back_leg.z -= AnimUtil.wave(walkTime + 0.75f) * walkPower * 3.0f;
        this.neck.y += AnimUtil.wave(walkTime * 2.0f - 0.2f) * walkPower * -0.2f;
        this.neck.xRot += AnimUtil.wave(walkTime * 2.0f) * walkPower * -0.005f;
        this.head.y += AnimUtil.wave(walkTime * 2.0f - 0.4f) * walkPower * -0.1f;
        this.tail.y += AnimUtil.wave(walkTime * 2.0f + 0.2f) * walkPower * -0.1f;
        float earZRot = (AnimUtil.wave(walkTime * 2.0f - 0.4f) / 2.0f + 0.5f) * walkPower * 0.1f;
        this.left_ear.zRot -= earZRot;
        this.right_ear.zRot += earZRot;
        float earXRot = (AnimUtil.wave(walkTime * 2.0f - 0.7f) / 2.0f + 0.5f) * walkPower * 0.1f;
        this.left_ear.xRot += earXRot;
        this.right_ear.xRot += earXRot;
        float runTime = limbSwing * 0.1f;
        float runPower = limbSwingAmount * 1.0f * runWeight;
        this.neck.xRot += runPower * 0.2f;
        this.head.xRot -= runPower * 0.2f;
        this.head.z += runPower * 0.5f;
        bodyYOffset2 = AnimUtil.wave(runTime + 0.1f) * runPower;
        this.upper_body.y += bodyYOffset2;
        this.upper_body.z += AnimUtil.wave(runTime - 0.25f + 0.1f) * 2.0f;
        this.lower_body.y += bodyYOffset2 * 0.25f;
        this.left_front_leg.y -= bodyYOffset2;
        this.right_front_leg.y -= bodyYOffset2;
        this.left_back_leg.y -= bodyYOffset2 * 1.5f;
        this.right_back_leg.y -= bodyYOffset2 * 1.5f;
        this.left_front_leg.xRot += AnimUtil.wave(runTime + 0.2f) * runPower * -0.8f;
        this.right_front_leg.xRot += AnimUtil.wave(runTime + 0.3f) * runPower * -0.8f;
        this.left_front_leg.z += AnimUtil.wave(runTime - 0.25f + 0.2f) * 1.0f;
        this.right_front_leg.z += AnimUtil.wave(runTime - 0.25f + 0.2f) * 1.0f;
        this.left_back_leg.xRot += (AnimUtil.wave(runTime + 0.7f) - 0.25f) * runPower * -0.5f;
        this.right_back_leg.xRot += (AnimUtil.wave(runTime + 0.5f) - 0.25f) * runPower * -0.5f;
        this.left_back_leg.z += AnimUtil.wave(runTime - 0.25f + 0.2f) * 1.0f;
        this.right_back_leg.z += AnimUtil.wave(runTime - 0.25f + 0.2f) * 1.0f;
        this.neck.y += AnimUtil.wave(runTime) * runPower * 0.5f;
        this.neck.xRot += (AnimUtil.wave(runTime) / 2.0f + 0.5f) * runPower * 0.05f;
        this.head.y += AnimUtil.wave(runTime - 0.3f) * runPower * 0.5f;
        this.neck.xRot += (AnimUtil.wave(runTime - 0.3f) / 2.0f + 0.5f) * runPower * 0.05f;
        float earXRot2 = (AnimUtil.wave(runTime) / 2.0f + 0.5f) * runPower * 0.2f;
        this.left_ear.xRot += earXRot2;
        this.right_ear.xRot += earXRot2;
    }
}

