/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model.goose;

import com.farcr.nomansland.client.model.goose.GooseAnimation;
import com.farcr.nomansland.common.entity.goose.Goose;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class GooseModel<T extends Goose>
extends AgeableHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightFlightWing;
    private final ModelPart leftFlightWing;
    private final ModelPart tail;
    private final ModelPart bodyBaby;
    private final ModelPart headBaby;
    private final ModelPart rightLegBaby;
    private final ModelPart leftLegBaby;

    public GooseModel(ModelPart root) {
        super(1.0f, 0.0f);
        this.root = root;
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.rightLeg = this.body.getChild("right_leg");
        this.leftLeg = this.body.getChild("left_leg");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
        this.rightFlightWing = this.body.getChild("right_flight_wing");
        this.leftFlightWing = this.body.getChild("left_flight_wing");
        this.tail = this.body.getChild("tail");
        this.bodyBaby = root.getChild("body_baby");
        this.headBaby = this.bodyBaby.getChild("head_baby");
        this.rightLegBaby = this.bodyBaby.getChild("right_leg_baby");
        this.leftLegBaby = this.bodyBaby.getChild("left_leg_baby");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.0f, -4.5f, 7.0f, 6.0f, 9.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-1.5f, -10.0f, -2.0f, 3.0f, 12.0f, 3.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)-3.5f));
        head.addOrReplaceChild("bill", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.5f, -3.5f, 2.0f, 3.0f, 2.0f).texOffs(23, 0).addBox(-1.0f, 0.5f, -4.5f, 2.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)-8.5f, (float)-0.5f));
        body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(44, 0).mirror().addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 2.0f).mirror(false), PartPose.offset((float)-2.0f, (float)3.0f, (float)0.5f));
        body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(44, 0).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 2.0f), PartPose.offset((float)2.0f, (float)3.0f, (float)0.5f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(46, 0).addBox(0.0f, 0.0f, -4.0f, 1.0f, 5.0f, 8.0f), PartPose.offset((float)3.5f, (float)-3.0f, (float)-0.5f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(46, 0).mirror().addBox(-1.0f, 0.0f, -4.0f, 1.0f, 5.0f, 8.0f).mirror(false), PartPose.offset((float)-3.5f, (float)-3.0f, (float)-0.5f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(41, 13).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)4.5f));
        body.addOrReplaceChild("left_flight_wing", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -0.5f, -1.5f, 17.0f, 1.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offset((float)3.5f, (float)-2.5f, (float)-3.0f));
        body.addOrReplaceChild("right_flight_wing", CubeListBuilder.create().texOffs(0, 15).mirror().addBox(-17.0f, -0.5f, -1.5f, 17.0f, 1.0f, 7.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offset((float)-3.5f, (float)-2.5f, (float)-3.0f));
        PartDefinition bodyBaby = partdefinition.addOrReplaceChild("body_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.5f, -1.0f, 4.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)20.5f, (float)-0.5f));
        bodyBaby.addOrReplaceChild("head_baby", CubeListBuilder.create().texOffs(0, 7).addBox(-1.5f, -2.0f, -3.0f, 3.0f, 3.0f, 3.0f).texOffs(12, 0).addBox(-0.5f, -1.0f, -4.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        bodyBaby.addOrReplaceChild("right_leg_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)-1.0f, (float)1.5f, (float)1.0f));
        bodyBaby.addOrReplaceChild("left_leg_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)1.0f, (float)1.5f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T goose, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180) / 3.0f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) / 3.0f;
        if (!((Goose)((Object)goose)).hurtingAnimationState.isStarted()) {
            if (((Goose)((Object)goose)).getState() == Goose.State.RUNNING) {
                this.animateWalk(GooseAnimation.GOOSE_RUN, limbSwing, limbSwingAmount, 2.0f, 3.0f);
            } else if (goose.isInWater()) {
                this.animateWalk(GooseAnimation.GOOSE_SWIM, limbSwing, limbSwingAmount, 4.0f, 5.0f);
            } else {
                this.animateWalk(GooseAnimation.GOOSE_WALK, limbSwing, limbSwingAmount, 4.0f, 5.0f);
                this.animate(((Goose)((Object)goose)).intimidatingAnimationState, GooseAnimation.GOOSE_INTIMIDATE, ageInTicks);
                this.animate(((Goose)((Object)goose)).fallingAnimationState, GooseAnimation.GOOSE_FALL, ageInTicks);
            }
        }
        this.animate(((Goose)((Object)goose)).hurtingAnimationState, GooseAnimation.GOOSE_HURT, ageInTicks);
        boolean baby = goose.isBaby();
        if (baby) {
            this.rightFlightWing.visible = false;
            this.leftFlightWing.visible = false;
            this.rightWing.visible = false;
            this.leftWing.visible = false;
        } else {
            boolean wingsVisible;
            this.rightFlightWing.visible = wingsVisible = ((Goose)((Object)goose)).showWings();
            this.leftFlightWing.visible = wingsVisible;
            this.rightWing.visible = !wingsVisible;
            this.leftWing.visible = !wingsVisible;
        }
        this.head.visible = !baby;
        this.rightLeg.visible = !baby;
        this.leftLeg.visible = !baby;
        this.tail.visible = !baby;
        this.body.visible = !baby;
        this.bodyBaby.visible = baby;
        this.bodyBaby.xRot = this.body.xRot;
        this.bodyBaby.yRot = this.body.yRot;
        this.headBaby.xRot = this.head.xRot / 2.0f;
        this.headBaby.yRot = this.head.yRot / 2.0f;
        this.rightLegBaby.xRot = this.rightLeg.xRot / 2.0f;
        this.leftLegBaby.xRot = this.leftLeg.xRot / 2.0f;
    }

    public ModelPart root() {
        return this.root;
    }
}

