/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.registry;

import dev.xylonity.knightquest.KnightQuestCommon;
import dev.xylonity.knightquest.common.entity.boss.NethermanCloneEntity;
import dev.xylonity.knightquest.common.entity.boss.NethermanEntity;
import dev.xylonity.knightquest.common.entity.boss.NethermanProjectileChargeEntity;
import dev.xylonity.knightquest.common.entity.entities.BadPatchEntity;
import dev.xylonity.knightquest.common.entity.entities.EldBombEntity;
import dev.xylonity.knightquest.common.entity.entities.EldKnightEntity;
import dev.xylonity.knightquest.common.entity.entities.FallenKnightEntity;
import dev.xylonity.knightquest.common.entity.entities.GhastlingEntity;
import dev.xylonity.knightquest.common.entity.entities.GhostyEntity;
import dev.xylonity.knightquest.common.entity.entities.GremlinEntity;
import dev.xylonity.knightquest.common.entity.entities.LizzyEntity;
import dev.xylonity.knightquest.common.entity.entities.RatmanEntity;
import dev.xylonity.knightquest.common.entity.entities.SamhainEntity;
import dev.xylonity.knightquest.common.entity.entities.SwampmanAxeEntity;
import dev.xylonity.knightquest.common.entity.entities.SwampmanEntity;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;

public class KnightQuestEntities {
    public static final Supplier<EntityType<GremlinEntity>> GREMLIN = KnightQuestEntities.register("gremlin", GremlinEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
    public static final Supplier<EntityType<EldBombEntity>> ELDBOMB = KnightQuestEntities.register("eldbomb", EldBombEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
    public static final Supplier<EntityType<EldKnightEntity>> ELDKNIGHT = KnightQuestEntities.register("eldknight", EldKnightEntity::new, MobCategory.MONSTER, 1.0f, 2.6f);
    public static final Supplier<EntityType<SwampmanEntity>> SWAMPMAN;
    public static final Supplier<EntityType<FallenKnightEntity>> FALLEN_KNIGHT;
    public static final Supplier<EntityType<SamhainEntity>> SAMHAIN;
    public static final Supplier<EntityType<RatmanEntity>> RATMAN;
    public static final Supplier<EntityType<LizzyEntity>> LIZZY;
    public static final Supplier<EntityType<BadPatchEntity>> BADPATCH;
    public static final Supplier<EntityType<GhastlingEntity>> SHIELD;
    public static final Supplier<EntityType<GhostyEntity>> GHOSTY;
    public static final Supplier<EntityType<NethermanEntity>> NETHERMAN;
    public static final Supplier<EntityType<NethermanCloneEntity>> NETHERMAN_CLONE;
    public static final Supplier<EntityType<NethermanProjectileChargeEntity>> NETHERMAN_PROJECTILE_CHARGE;
    public static final Supplier<EntityType<SwampmanAxeEntity>> SWAMPMAN_AXE;

    public static void init() {
    }

    private static <X extends Entity> Supplier<EntityType<X>> register(String name, EntityType.EntityFactory<X> entity, MobCategory spawnGroup, float width, float height) {
        return KnightQuestCommon.COMMON_PLATFORM.registerEntity(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)spawnGroup).sized(width, height).build(name));
    }

    public static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> registrar) {
        registrar.accept(GREMLIN.get(), GremlinEntity.setAttributes().build());
        registrar.accept(ELDBOMB.get(), EldBombEntity.setAttributes().build());
        registrar.accept(ELDKNIGHT.get(), EldKnightEntity.setAttributes().build());
        registrar.accept(SWAMPMAN.get(), SwampmanEntity.setAttributes().build());
        registrar.accept(RATMAN.get(), RatmanEntity.setAttributes().build());
        registrar.accept(SAMHAIN.get(), SamhainEntity.setAttributes().build());
        registrar.accept(LIZZY.get(), LizzyEntity.setAttributes().build());
        registrar.accept(BADPATCH.get(), BadPatchEntity.setAttributes().build());
        registrar.accept(SHIELD.get(), GhastlingEntity.setAttributes().build());
        registrar.accept(GHOSTY.get(), GhostyEntity.setAttributes().build());
        registrar.accept(NETHERMAN.get(), NethermanEntity.setAttributes().build());
        registrar.accept(NETHERMAN_CLONE.get(), NethermanCloneEntity.setAttributes().build());
        registrar.accept(FALLEN_KNIGHT.get(), FallenKnightEntity.setAttributes().build());
    }

    static {
        SAMHAIN = KnightQuestEntities.register("samhain", SamhainEntity::new, MobCategory.MONSTER, 1.0f, 1.5f);
        SWAMPMAN = KnightQuestEntities.register("swampman", SwampmanEntity::new, MobCategory.MONSTER, 1.0f, 2.0f);
        FALLEN_KNIGHT = KnightQuestEntities.register("fallen_knight", FallenKnightEntity::new, MobCategory.MONSTER, 1.0f, 2.0f);
        RATMAN = KnightQuestEntities.register("ratman", RatmanEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        LIZZY = KnightQuestEntities.register("lizzy", LizzyEntity::new, MobCategory.AMBIENT, 1.0f, 0.3f);
        BADPATCH = KnightQuestEntities.register("bad_patch", BadPatchEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        SHIELD = KnightQuestEntities.register("ghastling", GhastlingEntity::new, MobCategory.MONSTER, 0.65f, 0.65f);
        GHOSTY = KnightQuestEntities.register("ghosty", GhostyEntity::new, MobCategory.MONSTER, 1.0f, 1.0f);
        NETHERMAN = KnightQuestEntities.register("netherman", NethermanEntity::new, MobCategory.MONSTER, 0.8f, 2.8f);
        NETHERMAN_CLONE = KnightQuestEntities.register("netherman_clone", NethermanCloneEntity::new, MobCategory.MONSTER, 0.8f, 2.8f);
        NETHERMAN_PROJECTILE_CHARGE = KnightQuestEntities.register("netherman_projectile_charge", NethermanProjectileChargeEntity::new, MobCategory.MISC, 0.5f, 0.5f);
        SWAMPMAN_AXE = KnightQuestEntities.register("swampman_axe", SwampmanAxeEntity::new, MobCategory.MISC, 0.3f, 1.0f);
    }
}

