/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.item;

import dev.xylonity.knightlib.api.impl.GreatChaliceState;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.registry.KnightLibBlocks;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public abstract class KQWeaponItem
extends SwordItem {
    public KQWeaponItem(Tier pTier, Item.Properties pProperties) {
        super(pTier, pProperties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        Level level = ctx.getLevel();
        ItemStack stack = ctx.getItemInHand();
        BlockPos pos = ctx.getClickedPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GreatChaliceBlockEntity) {
            GreatChaliceBlockEntity be = (GreatChaliceBlockEntity)blockEntity;
            if (!level.isClientSide && be.isFull() && be.getState() == GreatChaliceState.CHAOTIC) {
                be.setCharges(0);
                level.playSound(null, pos, SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
                CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                CompoundTag dataTag = customData.copyTag();
                if (!dataTag.getBoolean("Activated")) {
                    dataTag.putBoolean("Activated", true);
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        int cooldownTicks;
        long lastUsed;
        BlockState blockState;
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult blockHit = KQWeaponItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHit.getType() == HitResult.Type.BLOCK && (blockState = level.getBlockState(blockHit.getBlockPos())).is((Block)KnightLibBlocks.GREAT_CHALICE.get())) {
            return InteractionResultHolder.fail((Object)stack);
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag dataTag = customData.copyTag();
        if (!dataTag.getBoolean("Activated")) {
            return InteractionResultHolder.fail((Object)stack);
        }
        long currentTime = level.getGameTime();
        if (currentTime - (lastUsed = dataTag.getLong("LastUsed")) >= (long)(cooldownTicks = this.getCooldownTicks())) {
            this.interaction(level, player, hand);
            if (!level.isClientSide) {
                dataTag.putLong("LastUsed", currentTime);
                player.getCooldowns().addCooldown((Item)this, cooldownTicks);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        if (this.isEnabled()) {
            pTooltipComponents.add((Component)Component.translatable((String)("tooltip.weapon.knightquest." + this.getName())));
            CustomData customData = (CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag dataTag = customData.copyTag();
            boolean isActivated = dataTag.getBoolean("Activated");
            if (!isActivated) {
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.weapon.knightquest.disabled_abilities"));
            }
            pTooltipComponents.add((Component)Component.translatable((String)("tooltip.weapon.knightquest." + this.getName() + ".active"), (Object[])new Object[]{Float.valueOf((float)KQConfigValues.SPEED_TICKS_KUKRI.get().intValue() / 20.0f), Float.valueOf((float)KQConfigValues.INV_TICKS_PALADIN.get().intValue() / 20.0f), (int)Math.floor(KQConfigValues.EXTRA_DAMAGE_UCHIGATANA.get() * 100.0), Float.valueOf((float)KQConfigValues.REFLECTION_TIME_KHOPESH.get().intValue() / 20.0f), KQConfigValues.TICKS_CLEAVER.get() / 20}));
            pTooltipComponents.add((Component)Component.translatable((String)("tooltip.weapon.knightquest." + this.getName() + ".passive"), (Object[])new Object[]{(int)Math.floor(KQConfigValues.EXTRA_DAMAGE_PASSIVE_UCHIGATANA.get() * 100.0), (int)Math.floor(KQConfigValues.ENEMY_HEALTH_PASSIVE_UCHIGATANA.get() * 100.0), (int)Math.floor(KQConfigValues.CHANCE_BURN_KHOPESH.get() * 100.0), KQConfigValues.REGEN_HP_PALADIN.get(), KQConfigValues.REGEN_TICKS_PALADIN.get() / 20, (int)Math.floor(KQConfigValues.REGEN_MAX_PALADIN.get().floatValue() * 100.0f), (int)Math.floor(KQConfigValues.EXTRA_DAMAGE_PASSIVE_CLEAVER.get() * 100.0), (int)Math.floor(KQConfigValues.ENEMY_HEALTH_PASSIVE_CLEAVER.get() * 100.0)}));
            if (!isActivated) {
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.weapon.knightquest.use_chalice"));
            }
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public abstract void interaction(Level var1, Player var2, InteractionHand var3);

    public abstract int getCooldownTicks();

    public abstract String getName();

    protected abstract boolean isEnabled();
}

