/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.event;

import dev.xylonity.knightquest.common.item.KQArmorItem;
import dev.xylonity.knightquest.common.item.KQFullSetChecker;
import dev.xylonity.knightquest.common.item.weapons.CleaverWeapon;
import dev.xylonity.knightquest.common.item.weapons.KhopeshWeapon;
import dev.xylonity.knightquest.common.item.weapons.NailWeapon;
import dev.xylonity.knightquest.common.item.weapons.PaladinWeapon;
import dev.xylonity.knightquest.common.item.weapons.UchigatanaWeapon;
import dev.xylonity.knightquest.common.material.KQArmorMaterials;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import dev.xylonity.knightquest.registry.KnightQuestWeapons;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class KQArmorEvents {
    private static final Map<UUID, Boolean> doubleJumpStates = new ConcurrentHashMap<UUID, Boolean>();
    private static final MobEffectInstance HUSK_ARMOR = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, -1, 1, false, false, true);
    private static final MobEffectInstance BAMBOO_BLUE = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 1, false, false, true);
    private static final MobEffectInstance SILVERFISH_ARMOR = new MobEffectInstance(MobEffects.DIG_SPEED, -1, 0, false, false, true);

    private static boolean isTeleportPositionValid(Level level, BlockPos pos) {
        return !level.getBlockState(pos.below()).isAir() && level.getBlockState(pos).isAir() && level.getBlockState(pos.above()).isAir();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSideDoubleJump(Player player) {
        boolean canDoubleJump;
        if (Minecraft.getInstance().options.keyJump.isDown() && (canDoubleJump = doubleJumpStates.getOrDefault(player.getUUID(), true).booleanValue())) {
            doubleJumpStates.put(player.getUUID(), false);
            for (int i = 0; i < 360; i += 60) {
                double angleRadians = Math.toRadians(i);
                double particleX = player.getX() + 0.4 * Math.cos(angleRadians);
                double particleZ = player.getZ() + 0.4 * Math.sin(angleRadians);
                player.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, particleX, player.getY(), particleZ, 0.0, 0.35, 0.0);
            }
            player.jumpFromGround();
        }
    }

    @EventBusSubscriber(modid="knightquest")
    public static class ArmorStatusManagerEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingIncomingDamageEvent event) {
            Object random5;
            CompoundTag dataTag;
            CustomData customData;
            LivingEntity stack;
            Player player;
            LivingEntity livingEntity;
            Entity entity2 = event.getSource().getEntity();
            if (entity2 instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).getMainHandItem().getItem() == KnightQuestWeapons.KUKRI.get() && KQConfigValues.KUKRI.get().booleanValue()) {
                event.getEntity().setTicksFrozen(event.getEntity().getTicksFrozen() + KQConfigValues.FREEZE_TICKS_KUKRI.get());
            }
            if ((entity2 = event.getSource().getEntity()) instanceof Player) {
                player = (Player)entity2;
                if (event.getEntity() != null) {
                    stack = player.getMainHandItem();
                    if (stack.getItem() instanceof UchigatanaWeapon && KQConfigValues.UCHIGATANA.get().booleanValue()) {
                        customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                        dataTag = customData.copyTag();
                        if (dataTag.getBoolean("ShouldDoActiveAttack")) {
                            dataTag.putBoolean("ShouldDoActiveAttack", false);
                            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
                            event.setAmount(event.getAmount() + event.getAmount() * KQConfigValues.EXTRA_DAMAGE_UCHIGATANA.get().floatValue());
                            event.getEntity().addEffect(new MobEffectInstance(MobEffects.DARKNESS, 80, 1, false, false));
                        }
                        if (event.getEntity().getHealth() < KQConfigValues.ENEMY_HEALTH_PASSIVE_UCHIGATANA.get().floatValue() * event.getEntity().getMaxHealth()) {
                            event.setAmount(event.getAmount() + event.getAmount() * KQConfigValues.EXTRA_DAMAGE_PASSIVE_UCHIGATANA.get().floatValue());
                        }
                    }
                    if (stack.getItem() instanceof CleaverWeapon && KQConfigValues.CLEAVER.get().booleanValue() && event.getEntity().getHealth() > KQConfigValues.ENEMY_HEALTH_PASSIVE_CLEAVER.get().floatValue() * event.getEntity().getMaxHealth()) {
                        event.setAmount(event.getAmount() + event.getAmount() * KQConfigValues.EXTRA_DAMAGE_PASSIVE_CLEAVER.get().floatValue());
                    }
                }
            }
            if ((stack = event.getEntity()) instanceof Player && (stack = (player = (Player)stack).getMainHandItem()).getItem() instanceof KhopeshWeapon && event.getSource().getEntity() != null && KQConfigValues.KHOPESH.get().booleanValue()) {
                customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                dataTag = customData.copyTag();
                if ((float)(player.level().getGameTime() - dataTag.getLong("KhopeshActive")) < KQConfigValues.REFLECTION_TIME_KHOPESH.get().floatValue()) {
                    event.getSource().getEntity().hurt(event.getSource(), event.getAmount() * 0.5f);
                }
            }
            if ((stack = event.getSource().getEntity()) instanceof LivingEntity && (livingEntity = stack).getMainHandItem().getItem() == KnightQuestWeapons.KHOPESH.get() && KQConfigValues.KHOPESH.get().booleanValue() && livingEntity.getRandom().nextFloat() <= KQConfigValues.CHANCE_BURN_KHOPESH.get().floatValue()) {
                event.getEntity().setRemainingFireTicks((livingEntity.getRandom().nextInt(7) + 1) * 20);
            }
            if ((stack = event.getEntity()) instanceof Player) {
                Random random2;
                player = (Player)stack;
                if (KQConfigValues.DEEPSLATESET.get().booleanValue() && event.getSource().is(DamageTypes.FALL) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DEEPSLATESET)) {
                    float originalDamage = event.getAmount();
                    float reducedDamage = originalDamage * KQConfigValues.DEEPSLATE_FALL_DAMAGE_MULTIPLIER.get().floatValue();
                    event.setAmount(reducedDamage);
                }
                if (KQConfigValues.EVOKERSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.EVOKERSET)) {
                    Random random3 = new Random();
                    if (event.getSource().getEntity() != null && (dataTag = event.getSource().getEntity()) instanceof LivingEntity) {
                        LivingEntity entity3 = (LivingEntity)dataTag;
                        if (random3.nextFloat() < KQConfigValues.EVOKER_DARKNESS_CHANCE.get().floatValue()) {
                            entity3.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 120, 0, false, false, true));
                        }
                    }
                }
                if (KQConfigValues.SQUIRESET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SQUIRESET)) {
                    event.setAmount(event.getAmount() * KQConfigValues.SQUIRE_DAMAGE_RECEIVED_MULTIPLIER.get().floatValue());
                }
                if (KQConfigValues.BLAZESET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BLAZESET)) {
                    Random random4 = new Random();
                    if (event.getSource().getEntity() != null && random4.nextFloat() < KQConfigValues.BLAZE_FIRE_CHANCE.get().floatValue()) {
                        event.getSource().getEntity().setRemainingFireTicks(random4.nextInt(KQConfigValues.BLAZE_FIRE_DURATION_MIN.get(), KQConfigValues.BLAZE_FIRE_DURATION_MAX.get()) * 20);
                    }
                }
                if (KQConfigValues.DRAGONSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET) && event.getSource().is(DamageTypes.DRAGON_BREATH)) {
                    event.setAmount(0.0f);
                }
                if (KQConfigValues.BAMBOOSET_GREEN.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_GREEN) && player.hasEffect(MobEffects.POISON)) {
                    player.removeEffect(MobEffects.POISON);
                    event.setCanceled(true);
                }
                if (KQConfigValues.SHINOBI.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHINOBI) && event.getSource().getEntity() != null) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, 1, false, false, true));
                }
                if (KQConfigValues.BAMBOOSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET) && event.getSource().is(DamageTypes.FALL)) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int particleCount = 80;
                    double particleRadius = 1.2;
                    for (int i = 0; i < particleCount; ++i) {
                        double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
                        double xParticleOffset = particleRadius * Math.cos(angleOffset);
                        double zParticleOffset = particleRadius * Math.sin(angleOffset);
                        serverPlayer.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, player.getX() + xParticleOffset, player.getY() + 0.1, player.getZ() + zParticleOffset, 0.2f, 0.05f, 0.2f, 0.0f, 1));
                    }
                    Class classToPush = KQConfigValues.ENABLE_BAMBOOSET_PUSH_PLAYERS.get() != false ? Entity.class : Monster.class;
                    player.level().getEntitiesOfClass(classToPush, player.getBoundingBox().inflate(3.5)).forEach(entity -> {
                        Vec3 direction = entity.position().subtract(player.position()).normalize().scale((double)event.getAmount() * 0.5);
                        entity.push(direction.x, direction.y + 0.5, direction.z);
                    });
                }
                if (KQConfigValues.ENDERMANSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ENDERMANSET) && event.getSource().getEntity() != null && (double)(random2 = new Random()).nextFloat() < 0.3) {
                    int radius = KQConfigValues.TELEPORT_RADIUS_ENDERMANSET.get();
                    BlockPos playerPos = player.blockPosition();
                    ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                BlockPos targetPos = new BlockPos(playerPos.getX() + x, playerPos.getY() + y, playerPos.getZ() + z);
                                if (!KQArmorEvents.isTeleportPositionValid(player.level(), targetPos)) continue;
                                validPositions.add(targetPos);
                            }
                        }
                    }
                    if (!validPositions.isEmpty()) {
                        BlockPos randomPos = (BlockPos)validPositions.get(random2.nextInt(validPositions.size()));
                        event.setAmount(0.0f);
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.teleportTo((double)randomPos.getX(), (double)randomPos.getY(), (double)randomPos.getZ());
                    }
                }
                if (KQConfigValues.VETERANSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.VETERANSET) && (double)player.getHealth() < (double)player.getMaxHealth() * 0.5) {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 0, false, false, true));
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 1, false, false, true));
                }
                if (KQConfigValues.FORZESET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.FORZESET)) {
                    Random random5 = new Random();
                    if (event.getSource().getEntity() != null && random5.nextFloat() < KQConfigValues.FORZESET_DEFLECT_CHANCE.get().floatValue()) {
                        event.getSource().getEntity().hurt(event.getSource(), event.getAmount() * KQConfigValues.FORZESET_DEFLECT_DAMAGE.get().floatValue());
                    }
                }
                if (KQConfigValues.CREEPERSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CREEPERSET) && event.getSource().getEntity() != null && (event.getSource().is(DamageTypes.EXPLOSION) || event.getSource().is(DamageTypes.PLAYER_EXPLOSION))) {
                    event.setAmount(event.getAmount() * KQConfigValues.CREEPER_EXPLOSION_DAMAGE_MULTIPLIER.get().floatValue());
                }
                if (KQConfigValues.POLAR.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && event.getSource().getEntity() != null && event.getSource().is(DamageTypes.FREEZE)) {
                    event.setAmount(0.0f);
                }
            }
            if ((random5 = event.getSource().getEntity()) instanceof Player) {
                player = (Player)random5;
                if (KQConfigValues.SILVERSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SILVERSET) && player.level().isNight() && ((Random)(random5 = new Random())).nextFloat() < KQConfigValues.SILVERSET_BURN_CHANCE.get().floatValue()) {
                    event.getEntity().setRemainingFireTicks(random5.nextInt(2, 8) * 20);
                }
                if (KQConfigValues.HOLLOWSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HOLLOWSET)) {
                    player.heal(Math.min(event.getAmount() * KQConfigValues.HOLLOWSET_HEALING_MULTIPLIER.get().floatValue(), event.getEntity().getHealth()));
                }
                if (KQConfigValues.DRAGONSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET)) {
                    event.setAmount(event.getAmount() * KQConfigValues.DRAGONSET_DAMAGE_MULTIPLIER.get().floatValue());
                }
                if (KQConfigValues.WITHERSET.get().booleanValue() && event.getSource().is(DamageTypes.ARROW) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITHERSET)) {
                    random5 = new Random();
                    if (event.getSource().getEntity() != null && ((Random)random5).nextFloat() < KQConfigValues.WITHERSET_WITHER_CHANCE.get().floatValue()) {
                        event.getEntity().addEffect(new MobEffectInstance(MobEffects.WITHER, 120, 0, false, false, false));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingUpdate(LivingEntityUseItemEvent.Finish event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (KQConfigValues.APPLE_SET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.APPLE_SET) && event.getItem().getItem().equals(Items.APPLE)) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0, false, true, true));
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDead(LivingDeathEvent event) {
            Entity entity;
            if (event.getSource().getEntity() != null && (entity = event.getSource().getEntity()) instanceof Player) {
                Player player = (Player)entity;
                if (KQConfigValues.CONQUISTADORSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CONQUISTADORSET)) {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 1, false, true, true));
                }
                if (KQConfigValues.WITCH.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITCH)) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, 0, false, true, true));
                }
            }
        }

        @SubscribeEvent
        public static void onArrowHit(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof AbstractArrow) {
                Player player;
                Entity entity2;
                AbstractArrow arrow = (AbstractArrow)entity;
                if (KQConfigValues.SKELETONSET.get().booleanValue() && (entity2 = arrow.getOwner()) instanceof Player && KQFullSetChecker.hasFullSetOn(player = (Player)entity2, KQArmorMaterials.SKELETONSET)) {
                    arrow.setPierceLevel((byte)5);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingTick(EntityTickEvent.Post event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack helmet = player.getInventory().getArmor(3);
                ItemStack stack = player.getMainHandItem();
                CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                CompoundTag dataTag = customData.copyTag();
                if (stack.getItem() instanceof PaladinWeapon && KQConfigValues.PALADIN.get().booleanValue() && player.tickCount % KQConfigValues.REGEN_TICKS_PALADIN.get() == 0 && player.getHealth() < player.getMaxHealth() * KQConfigValues.REGEN_MAX_PALADIN.get().floatValue() && dataTag.getBoolean("Activated")) {
                    player.heal(KQConfigValues.REGEN_HP_PALADIN.get().floatValue());
                }
                if ((KQConfigValues.TENGU_HELMET.get().booleanValue() || KQConfigValues.NAIL.get().booleanValue()) && (helmet.getItem().equals(KnightQuestItems.TENGU_HELMET.get()) || stack.getItem() instanceof NailWeapon && dataTag.getBoolean("Activated"))) {
                    boolean canDoubleJump = doubleJumpStates.getOrDefault(player.getUUID(), true);
                    if (!player.onGround() && player.getDeltaMovement().y < 0.0 && canDoubleJump && FMLEnvironment.dist == Dist.CLIENT) {
                        KQArmorEvents.handleClientSideDoubleJump(player);
                    }
                    if (player.onGround()) {
                        doubleJumpStates.put(player.getUUID(), true);
                    }
                }
                if (KQConfigValues.HUSKSET.get().booleanValue()) {
                    if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HUSKSET) && (player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.DESERT) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.BADLANDS) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.BEACH))) {
                        if (!Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.HUSKSET, false))) {
                            player.addEffect(HUSK_ARMOR);
                            KQArmorItem.effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.HUSKSET, true);
                        }
                    } else if (Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.HUSKSET, false))) {
                        player.removeEffect(MobEffects.DAMAGE_RESISTANCE);
                        KQArmorItem.effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.HUSKSET, false);
                    }
                }
                if (KQConfigValues.BAMBOOSET_GREEN.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_GREEN) && player.hasEffect(MobEffects.POISON)) {
                    player.removeEffect(MobEffects.POISON);
                }
                if (KQConfigValues.BAMBOOSET_BLUE.get().booleanValue()) {
                    if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_BLUE) && (player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.JUNGLE) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.BAMBOO_JUNGLE) || player.level().getBiome(new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ())).is(Biomes.SPARSE_JUNGLE))) {
                        if (!Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                            player.addEffect(BAMBOO_BLUE);
                            KQArmorItem.effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.BAMBOOSET_BLUE, true);
                        }
                    } else if (Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                        player.removeEffect(MobEffects.MOVEMENT_SPEED);
                        KQArmorItem.effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.BAMBOOSET_BLUE, false);
                    }
                }
                if (KQConfigValues.WARLORDSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WARLORDSET)) {
                    for (Entity entity2 : player.level().getEntitiesOfClass(Player.class, player.getBoundingBox().inflate((double)KQConfigValues.WARLORD_SET_EFFECT_RADIUS.get().intValue()))) {
                        Player nearbyPlayer;
                        if (KQConfigValues.SHOULD_WARLORD_SET_EFFECT_APPLY_TO_ITSELF.get().booleanValue()) {
                            if (!(entity2 instanceof Player)) continue;
                            nearbyPlayer = (Player)entity2;
                            nearbyPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0, false, false, true));
                            continue;
                        }
                        if (!(entity2 instanceof Player)) continue;
                        nearbyPlayer = (Player)entity2;
                        if (entity2 == player) continue;
                        nearbyPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0, false, false, true));
                    }
                }
                if (KQConfigValues.ZOMBIESET.get().booleanValue() && !player.level().isClientSide && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ZOMBIESET) && player.level().isNight() && player.tickCount % KQConfigValues.ZOMBIESET_HEALING_TICKS.get() == 0) {
                    player.heal(KQConfigValues.ZOMBIESET_HEALING_AMOUNT.get().floatValue());
                }
                if (KQConfigValues.POLAR.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && player.getTicksFrozen() > 0) {
                    player.setTicksFrozen(0);
                }
                if (KQConfigValues.SILVERFISHSET.get().booleanValue()) {
                    if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SILVERFISHSET) && player.getY() < (double)KQConfigValues.SILVERFISH_EFFECT_MAX_HEIGHT.get().intValue()) {
                        if (!Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SILVERFISHSET, false))) {
                            player.addEffect(SILVERFISH_ARMOR);
                            KQArmorItem.effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.SILVERFISHSET, true);
                        }
                    } else if (Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.getUUID(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SILVERFISHSET, false))) {
                        player.removeEffect(MobEffects.DIG_SPEED);
                        KQArmorItem.effectAppliedByArmorMap.get(player.getUUID()).put(KQArmorMaterials.SILVERFISHSET, false);
                    }
                }
            }
        }
    }
}

