/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.KnightQuestCommon;
import dev.xylonity.knightquest.common.entity.entities.ai.MoveToPumpkinGoal;
import dev.xylonity.knightquest.common.entity.entities.ai.RangedAttackGoal;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SamhainEntity
extends TamableAnimal
implements GeoEntity,
RangedAttackMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(SamhainEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SIT_VARIATION = SynchedEntityData.defineId(SamhainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SamhainEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setCanPickUpLoot(true);
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return Arrays.asList(this.getItemBySlot(EquipmentSlot.HEAD), this.getItemBySlot(EquipmentSlot.CHEST), this.getItemBySlot(EquipmentSlot.LEGS), this.getItemBySlot(EquipmentSlot.FEET));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.ATTACK_SPEED, 2.0).add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, new RangedAttackGoal<SamhainEntity>(this, 0.7, 10, 15.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 6.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new MoveToPumpkinGoal(this, 0.68f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate));
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.isUsingItem() && this.getMainHandItem().getItem() instanceof ProjectileWeaponItem) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("bow_attack", Animation.LoopType.PLAY_ONCE));
        } else if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isSitting()) {
            String sitVariation = this.getSitVariation() == 0 ? "sit" : (this.getSitVariation() == 1 ? "sit3" : "sit2");
            event.getController().setAnimation(RawAnimation.begin().then(sitVariation, Animation.LoopType.LOOP));
        } else if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item itemForTaming = KnightQuestCommon.COMMON_PLATFORM.getGreatEssence().get();
        Item item = itemstack.getItem();
        if (item == itemForTaming && !this.isTame()) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            if (!this.level().isClientSide) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.setSitting(true);
            }
            this.setSitVariation(this.getRandom().nextInt(0, 3));
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && !this.level().isClientSide && hand == InteractionHand.MAIN_HAND && this.getOwner() == player) {
            if ((itemstack.getItem().equals(KnightQuestCommon.COMMON_PLATFORM.getGreatEssence().get()) || itemstack.getItem().equals(KnightQuestCommon.COMMON_PLATFORM.getSmallEssence().get())) && this.getHealth() < this.getMaxHealth()) {
                if (itemstack.getItem().equals(KnightQuestCommon.COMMON_PLATFORM.getGreatEssence().get())) {
                    this.heal(16.0f);
                } else if (itemstack.getItem().equals(KnightQuestCommon.COMMON_PLATFORM.getSmallEssence().get())) {
                    this.heal(4.0f);
                }
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            } else if (player.isShiftKeyDown()) {
                this.removeArmor(player);
                this.removeItem(player);
            } else {
                this.setSitting(!this.isSitting());
                this.setSitVariation(this.getRandom().nextInt(0, 3));
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.getItem() == itemForTaming) {
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.getItem();
        Item item = itemStack.getItem();
        if ((item instanceof SwordItem || item instanceof AxeItem) && this.isTame()) {
            EquipmentSlot slot = this.getEquipmentSlotForItem(itemStack);
            ItemStack currentItem = this.getItemInHand(InteractionHand.MAIN_HAND);
            if (currentItem.isEmpty()) {
                this.setItemSlot(slot, itemStack.split(1));
                if (itemStack.isEmpty()) {
                    itemEntity.discard();
                }
            }
        } else if (item instanceof ArmorItem) {
            EquipmentSlot slot;
            ItemStack currentArmor;
            ArmorItem armorItem = (ArmorItem)item;
            if (this.isTame() && (currentArmor = this.getItemBySlot(slot = armorItem.getEquipmentSlot())).isEmpty()) {
                this.setItemSlot(slot, itemStack.split(1));
                if (itemStack.isEmpty()) {
                    itemEntity.discard();
                }
            }
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (this.getOwnerUUID() != null) {
            tag.putUUID("ownerUUID", this.getOwnerUUID());
        }
        this.setSitting(tag.getBoolean("isSitting"));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            CompoundTag stackNbt = tag.getCompound(slot.getName());
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)stackNbt);
            if (stack.isEmpty()) continue;
            this.setItemSlot(slot, stack);
        }
    }

    public boolean isFood(@NotNull ItemStack itemStack) {
        return false;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (tag.hasUUID("ownerUUID")) {
            this.setOwnerUUID(tag.getUUID("ownerUUID"));
        }
        tag.putBoolean("isSitting", this.isSitting());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (stack = this.getItemBySlot(slot)).isEmpty()) continue;
            CompoundTag stackNbt = new CompoundTag();
            stack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)stackNbt);
            tag.put(slot.getName(), (Tag)stackNbt);
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SITTING, (Object)false);
        pBuilder.define(SIT_VARIATION, (Object)0);
    }

    private void setSitVariation(int sitVariation) {
        this.entityData.set(SIT_VARIATION, (Object)sitVariation);
    }

    private int getSitVariation() {
        return (Integer)this.entityData.get(SIT_VARIATION);
    }

    private void removeArmor(Player pPlayer) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armorStack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (armorStack = this.getItemBySlot(slot)).isEmpty()) continue;
            boolean addedToInventory = pPlayer.getInventory().add(armorStack);
            if (!addedToInventory) {
                pPlayer.spawnAtLocation(armorStack);
            }
            this.setItemSlot(slot, ItemStack.EMPTY);
        }
    }

    private void removeItem(Player pPlayer) {
        ItemStack itemStack = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (!itemStack.isEmpty()) {
            boolean addedToInventory = pPlayer.getInventory().add(itemStack);
            if (!addedToInventory) {
                pPlayer.spawnAtLocation(itemStack);
            }
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
        this.setOrderedToSit(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setTame(boolean pTame, boolean pApplyTamingSideEffects) {
        super.setTame(pTame, pApplyTamingSideEffects);
        if (pTame) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(20.0);
            Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(0.5);
            Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(0.5);
            this.setHealth(20.0f);
        } else {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(8.0);
            Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(0.5);
            Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(0.5);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    @NotNull
    protected SoundEvent getSwimSound() {
        return SoundEvents.AXOLOTL_SWIM;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ALLAY_DEATH;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.ALLAY_HURT;
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    protected AbstractArrow createArrowProjectile(ItemStack arrowStack, float pullProgress) {
        return ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)arrowStack, (float)pullProgress, (ItemStack)this.getMainHandItem());
    }

    public void performRangedAttack(@NotNull LivingEntity pTarget, float pVelocity) {
        ItemStack itemstack = this.getProjectile(this.getMainHandItem());
        AbstractArrow abstractarrow = this.getArrow(itemstack, pVelocity);
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            abstractarrow = this.createArrowProjectile(itemstack, pVelocity);
        }
        double d0 = pTarget.getX() - this.getX();
        double d1 = pTarget.getY(0.34) - abstractarrow.getY();
        double d2 = pTarget.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity, (ItemStack)this.getMainHandItem());
    }
}

