/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.boss.ai;

import dev.xylonity.knightquest.common.entity.boss.NethermanEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class NethermanTeleport2PlayerGoal
extends Goal {
    private final NethermanEntity netherman;
    private int idleTime;

    public NethermanTeleport2PlayerGoal(NethermanEntity netherman) {
        this.netherman = netherman;
    }

    public boolean canUse() {
        return this.netherman.getTarget() == null && (this.netherman.getPhase() == 1 && this.netherman.tickCount > 100 || this.netherman.getPhase() == 2 && this.netherman.getCounterSwitchPhase2() == 130 || this.netherman.getPhase() == 3 && this.netherman.getCounterSwitchPhase3() == 160);
    }

    public void start() {
        this.idleTime = 100;
    }

    public void stop() {
        this.idleTime = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private boolean isValidTeleportPosition(BlockPos pos) {
        if (this.netherman.level().getBlockState(pos).getBlock() != Blocks.AIR) {
            return false;
        }
        BlockPos blockBelow = pos.below();
        BlockState stateBelow = this.netherman.level().getBlockState(blockBelow);
        if (stateBelow.getBlock() == Blocks.AIR || stateBelow.getBlock() == Blocks.LAVA || stateBelow.getBlock() == Blocks.WATER) {
            return false;
        }
        AABB boundingBox = new AABB((double)pos.getX() - 0.5, (double)pos.getY(), (double)pos.getZ() - 0.5, (double)pos.getX() + 0.5, (double)((float)pos.getY() + this.netherman.getBbHeight()), (double)pos.getZ() + 0.5);
        return this.netherman.level().noCollision((Entity)this.netherman, boundingBox);
    }

    private void teleportNearPlayer() {
        List players = this.netherman.level().players();
        Player closestPlayer = players.stream().filter(player -> !player.isCreative() && !player.isSpectator()).min((p1, p2) -> Double.compare(p1.distanceTo((Entity)this.netherman), p2.distanceTo((Entity)this.netherman))).orElse(null);
        if (closestPlayer != null) {
            RandomSource random = this.netherman.getRandom();
            for (int attempt = 0; attempt < 50; ++attempt) {
                double angle = random.nextDouble() * 2.0 * Math.PI;
                double distance = 3.0 + random.nextDouble() * 7.0;
                double x = closestPlayer.getX() + Math.cos(angle) * distance;
                double z = closestPlayer.getZ() + Math.sin(angle) * distance;
                double y = closestPlayer.getY() + (random.nextDouble() - 0.5) * 2.0;
                BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
                if (!this.isValidTeleportPosition(targetPos)) continue;
                this.netherman.level().playSound(null, this.netherman.getX(), this.netherman.getY(), this.netherman.getZ(), SoundEvents.ENDERMAN_TELEPORT, this.netherman.getSoundSource(), 1.0f, 1.0f);
                this.netherman.teleportTo(x, y, z);
                this.netherman.level().playSound(null, x, y, z, SoundEvents.ENDERMAN_TELEPORT, this.netherman.getSoundSource(), 1.0f, 1.0f);
                return;
            }
        }
    }

    public void tick() {
        if (this.idleTime > 0) {
            --this.idleTime;
        }
        if (this.idleTime == 0) {
            this.teleportNearPlayer();
            this.idleTime = 100;
        }
    }
}

