/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.ai.navigator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BonusPathFinder
extends PathFinder {
    public BonusPathFinder(NodeEvaluator processor, int maxVisitedNodes) {
        super(processor, maxVisitedNodes);
    }

    public Path findPath(@NotNull PathNavigationRegion region, @NotNull Mob mob, @NotNull Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        Path path = super.findPath(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
        return path == null ? null : new CachedPath(path);
    }

    static class CachedPath
    extends Path {
        private final Cache<Integer, Vec3> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();

        public CachedPath(Path original) {
            super(CachedPath.copyNodes(original), original.getTarget(), original.canReach());
        }

        @NotNull
        public Vec3 getEntityPosAtNode(@NotNull Entity entity, int index) {
            try {
                return (Vec3)this.cache.get((Object)index, () -> this.computeEntityPosAtNode(entity, index));
            }
            catch (Exception e) {
                return this.computeEntityPosAtNode(entity, index);
            }
        }

        private Vec3 computeEntityPosAtNode(Entity entity, int index) {
            Node point = this.getNode(index);
            double offsetX = (double)Mth.floor((float)(entity.getBbWidth() + 1.0f)) * 0.5;
            double x = (double)point.x + offsetX;
            double y = point.y;
            double z = (double)point.z + offsetX;
            return new Vec3(x, y, z);
        }

        private static List<Node> copyNodes(Path original) {
            return (List)IntStream.range(0, original.getNodeCount()).mapToObj(arg_0 -> ((Path)original).getNode(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        }
    }
}

