/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.client.entity.model;

import dev.xylonity.knightquest.common.entity.entities.EldBombEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class EldBombModel
extends GeoModel<EldBombEntity> {
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"textures/entity/eldbomb.png");
    private static final ResourceLocation WHITE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"textures/entity/eldbomb_white.png");

    public ResourceLocation getModelResource(EldBombEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"geo/eldbomb.geo.json");
    }

    public ResourceLocation getTextureResource(EldBombEntity animatable) {
        if (animatable.getSwell() > 10) {
            if (animatable.tickCount / 5 % 2 == 0) {
                return WHITE_TEXTURE;
            }
            return DEFAULT_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    public ResourceLocation getAnimationResource(EldBombEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"animations/eldbomb.animation.json");
    }

    public void setCustomAnimations(EldBombEntity animatable, long instanceId, AnimationState<EldBombEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("Body");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

