/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest;

import dev.xylonity.knightquest.KnightQuestCommon;
import dev.xylonity.knightquest.config.KnightQuestCommonConfigs;
import dev.xylonity.knightquest.datagen.KQLootModifiers;
import dev.xylonity.knightquest.registry.KnightQuestCreativeModeTabs;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import dev.xylonity.knightquest.registry.KnightQuestWeapons;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="knightquest")
public class KnightQuest {
    public static final String MOD_ID = "knightquest";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"knightquest");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"knightquest");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"knightquest");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"knightquest");
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"knightquest");
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"knightquest");

    public KnightQuest(IEventBus modEventBus, ModContainer modContainer) {
        KQLootModifiers.LOOT_MODIFIER_SERIALIZERS.register(modEventBus);
        ARMOR_MATERIALS.register(modEventBus);
        SOUNDS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        PARTICLES.register(modEventBus);
        ENTITY.register(modEventBus);
        modEventBus.addListener(event -> KnightQuestEntities.registerEntityAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1)));
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)KnightQuestCommonConfigs.SPEC, "knightquest.toml");
        modEventBus.addListener(this::onCommonSetup);
        KnightQuestCreativeModeTabs.registerWeaponItem(KnightQuestWeapons.PALADIN_SWORD);
        KnightQuestCreativeModeTabs.registerWeaponItem(KnightQuestWeapons.KHOPESH);
        KnightQuestCreativeModeTabs.registerWeaponItem(KnightQuestWeapons.CLEAVER);
        KnightQuestCreativeModeTabs.registerWeaponItem(KnightQuestWeapons.KUKRI);
        KnightQuestCreativeModeTabs.registerWeaponItem(KnightQuestWeapons.UCHIGATANA);
        KnightQuestCreativeModeTabs.registerWeaponItem(KnightQuestWeapons.NAIL);
        KnightQuestCommon.init();
    }

    private void onCommonSetup(ModConfigEvent e) {
        if (e.getConfig().getType() == ModConfig.Type.COMMON) {
            KnightQuestCommonConfigs.assignValues();
        }
    }
}

