/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util.quests;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.init.GBuiltinLootTables;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GRegistries;
import net.orcinus.galosphere.util.quests.IndexedQuest;
import net.orcinus.galosphere.util.quests.MiningQuest;

public class MiningPouchManager {
    public static ItemStack getPouch(ServerLevel serverLevel, BlockPos blockPos) {
        IndexedQuest indexedQuest = MiningPouchManager.create(serverLevel, blockPos);
        ItemStack itemStack = new ItemStack((ItemLike)GItems.MINING_POUCH.get());
        itemStack.set(GDataComponents.QUESTS.get(), (Object)new IndexedQuest(indexedQuest.requests(), indexedQuest.rarity()));
        return itemStack;
    }

    public static ObjectArrayList<ItemStack> getPouchRewards(ServerLevel serverLevel, BlockPos blockPos, Rarity rarity) {
        ResourceKey resourcekey;
        List<MiningQuest> miningQuest = serverLevel.registryAccess().registryOrThrow(GRegistries.MINING_QUEST).stream().filter(quest -> quest.rarity() == rarity).toList();
        if (miningQuest.isEmpty()) {
            resourcekey = GBuiltinLootTables.MINING_QUESTS_COMMON_GIFT;
        } else {
            List<ResourceKey> key = miningQuest.stream().map(MiningQuest::gift).toList();
            resourcekey = key.get(serverLevel.getRandom().nextInt(key.size()));
        }
        return MiningPouchManager.generateItems(resourcekey, serverLevel, blockPos, 1);
    }

    public static IndexedQuest create(ServerLevel serverLevel, BlockPos blockPos) {
        MiningQuest randomQuest = MiningPouchManager.getRandomQuest(serverLevel);
        ObjectArrayList<ItemStack> required = MiningPouchManager.generateItems(randomQuest.required(), serverLevel, blockPos, 3);
        return new IndexedQuest((List<ItemStack>)required, randomQuest.rarity());
    }

    public static MiningQuest getRandomQuest(ServerLevel level) {
        List<MiningQuest> questsManager = level.registryAccess().registryOrThrow(GRegistries.MINING_QUEST).stream().toList();
        int randomValue = level.random.nextInt(MiningPouchManager.getTotalQuestWeight(questsManager));
        for (MiningQuest miningQuest : questsManager) {
            int i = randomValue - miningQuest.weight();
            if (i >= 0) continue;
            return miningQuest;
        }
        return questsManager.get(level.getRandom().nextInt(questsManager.size()));
    }

    private static int getTotalQuestWeight(List<MiningQuest> quests) {
        long l = 0L;
        for (MiningQuest miningQuest : quests) {
            l += (long)miningQuest.weight();
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l;
    }

    public static ObjectArrayList<ItemStack> generateItems(ResourceKey<LootTable> key, ServerLevel serverLevel, BlockPos blockPos, int count) {
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(key);
        ObjectArrayList result = new ObjectArrayList();
        if (count == 1) {
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).create(LootContextParamSets.VAULT);
            return lootTable.getRandomItems(lootParams);
        }
        for (int i = 0; i < 3; ++i) {
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).create(LootContextParamSets.VAULT);
            ObjectArrayList randomItems = lootTable.getRandomItems(lootParams);
            boolean skip = false;
            if (!result.isEmpty()) {
                for (ItemStack stack : result) {
                    if (!stack.is(((ItemStack)randomItems.get(0)).getItem())) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            result.add((Object)((ItemStack)randomItems.get(0)));
        }
        return result;
    }
}

