/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.orcinus.galosphere.init.GItems;
import org.jetbrains.annotations.NotNull;

public class PillagerPalladiumLootModifier
extends LootModifier {
    public static final MapCodec<PillagerPalladiumLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> PillagerPalladiumLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.INT.fieldOf("min").forGetter(m -> m.min), (App)Codec.INT.fieldOf("max").forGetter(m -> m.max))).apply((Applicative)instance, PillagerPalladiumLootModifier::new));
    private final int min;
    private final int max;

    public PillagerPalladiumLootModifier(LootItemCondition[] conditionsIn, int min, int max) {
        super(conditionsIn);
        this.min = min;
        this.max = max;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> objectArrayList, LootContext lootContext) {
        Holder.Reference looting = lootContext.getResolver().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING);
        DamageSource source = (DamageSource)lootContext.getParam(LootContextParams.DAMAGE_SOURCE);
        Entity entity = source.getEntity();
        int level = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            level = EnchantmentHelper.getEnchantmentLevel((Holder)looting, (LivingEntity)living);
        }
        int count = UniformInt.of((int)this.min, (int)this.max).sample(lootContext.getRandom()) + level;
        objectArrayList.add((Object)new ItemStack((ItemLike)GItems.PALLADIUM_NUGGET.get(), count));
        return objectArrayList;
    }
}

