/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin.client;

import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.orcinus.galosphere.init.GMobEffects;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Unique
    private static float DISTANCE = 24.0f;

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", shift=At.Shift.BEFORE)}, method={"setupFog"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void G$setupFog(Camera camera, FogRenderer.FogMode fogMode, float f, boolean bl, float g, CallbackInfo ci, FogType fogType, Entity entity, FogRenderer.FogData fogData) {
        LivingEntity livingEntity;
        Entity cameraEntity = camera.getEntity();
        if (cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).hasEffect(GMobEffects.ASTRAL)) {
            boolean lock;
            boolean bl2 = lock = FogRendererMixin.getViewBlockingState(livingEntity) != null;
            if (DISTANCE == f && !lock) {
                return;
            }
            if (DISTANCE > 12.0f && lock) {
                DISTANCE -= 2.0f;
            }
            if (!lock && DISTANCE < f) {
                DISTANCE += 1.0f;
            }
            float h = DISTANCE;
            fogData.start = fogData.mode == FogRenderer.FogMode.FOG_SKY ? 0.0f : h * 0.75f;
            fogData.end = h;
        }
    }

    @Unique
    @Nullable
    private static BlockState getViewBlockingState(LivingEntity player) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d = player.getX() + (double)(((float)(i % 2) - 0.5f) * player.getBbWidth() * 0.8f);
            double e = player.getEyeY() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = player.getZ() + (double)(((float)((i >> 2) % 2) - 0.5f) * player.getBbWidth() * 0.8f);
            mutableBlockPos.set(d, e, f);
            BlockState blockState = player.level().getBlockState((BlockPos)mutableBlockPos);
            if (blockState.getRenderShape() == RenderShape.INVISIBLE || !blockState.isViewBlocking((BlockGetter)player.level(), (BlockPos)mutableBlockPos)) continue;
            return blockState;
        }
        return null;
    }
}

