/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.ItemStack;
import net.orcinus.galosphere.api.HaliteCurse;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.items.components.SterlingAttached;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements HaliteCurse {
    @Unique
    private static final EntityDataAccessor<Boolean> HALITE_CURSED = SynchedEntityData.defineId(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Unique
    private final LivingEntity $this = (LivingEntity)this;

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void G$defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(HALITE_CURSED, (Object)false);
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void G$readAddtionalSavedData(CompoundTag compound, CallbackInfo ci) {
        this.setHaliteCurse(compound.getBoolean("HaliteCursed"));
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void G$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.putBoolean("HaliteCursed", this.isHaliteCursed());
    }

    @Inject(at={@At(value="HEAD")}, method={"isInWall"}, cancellable=true)
    private void G$isInWall(CallbackInfoReturnable<Boolean> cir) {
        if (this.$this.hasEffect(GMobEffects.ASTRAL)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean isHaliteCursed() {
        return (Boolean)this.$this.getEntityData().get(HALITE_CURSED);
    }

    @Override
    public void setHaliteCurse(boolean haliteTicks) {
        this.$this.getEntityData().set(HALITE_CURSED, (Object)haliteTicks);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/core/Holder;Lnet/minecraft/sounds/SoundSource;FFJ)V")}, method={"onEquipItem"})
    private void G$onEquipItem(EquipmentSlot equipmentSlot, ItemStack itemStack, ItemStack itemStack2, CallbackInfo ci) {
        boolean flag1;
        Horse horse;
        LivingEntity $this = (LivingEntity)this;
        boolean flag = $this instanceof Horse && (horse = (Horse)$this).getOwner() instanceof ServerPlayer;
        SterlingAttached attached = (SterlingAttached)itemStack2.getOrDefault(GDataComponents.STERLING_ATTACHED.get(), (Object)SterlingAttached.EMPTY);
        boolean bl = flag1 = itemStack2.is(GItems.STERLING_HORSE_ARMOR) && !attached.attached().isEmpty();
        if (flag && flag1) {
            GCriteriaTriggers.ATTACH_STERLING_HORSE.get().trigger((ServerPlayer)((Horse)$this).getOwner());
        }
    }
}

