/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GBiomeTags;
import net.orcinus.galosphere.init.GStructurePools;

public class GStructures {
    public static final ResourceKey<Structure> PINK_SALT_SHRINE = GStructures.createKey("pink_salt_shrine");
    public static final ResourceKey<Structure> FORGOTTEN_RUINS = GStructures.createKey("forgotten_ruins");

    public static void bootstrap(BootstrapContext<Structure> bootstrapContext) {
        HolderGetter holderGetter = bootstrapContext.lookup(Registries.BIOME);
        HolderGetter holderGetter1 = bootstrapContext.lookup(Registries.TEMPLATE_POOL);
        bootstrapContext.register(PINK_SALT_SHRINE, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)holderGetter.getOrThrow(GBiomeTags.HAS_PINK_SALT_SHRINE)).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_BOX).spawnOverrides(Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create())))).build(), (Holder)holderGetter1.getOrThrow(GStructurePools.PINK_SALT_SHRINE_START), Optional.empty(), 7, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-30), (VerticalAnchor)VerticalAnchor.absolute((int)30)), false, Optional.empty(), 80, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, LiquidSettings.IGNORE_WATERLOGGING));
        bootstrapContext.register(FORGOTTEN_RUINS, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)holderGetter.getOrThrow(GBiomeTags.HAS_FORGOTTEN_RUINS)).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_BOX).spawnOverrides(Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.SPIDER, 1, 1, 1)})))).build(), (Holder)holderGetter1.getOrThrow(GStructurePools.FORGOTTEN_RUINS_START), Optional.empty(), 5, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)3)), false, Optional.empty(), 80, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
    }

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Galosphere.id(name));
    }
}

