/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.orcinus.galosphere.world.gen.processors.ancient_cities.EchoAltarProcessor;
import net.orcinus.galosphere.world.gen.processors.decorations.ChiseledBookshelfProcessor;
import net.orcinus.galosphere.world.gen.processors.decorations.MultipleCandleProcessor;
import net.orcinus.galosphere.world.gen.processors.pink_salt_shrine.MainRoomProcessor;
import net.orcinus.galosphere.world.gen.processors.pink_salt_shrine.NoWaterloggedProcessor;
import net.orcinus.galosphere.world.gen.processors.pink_salt_shrine.RawOreProcessor;

public class GStructureProcessorTypes {
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSOR_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PROCESSOR, (String)"galosphere");
    public static final Supplier<StructureProcessorType<MainRoomProcessor>> PINK_SALT_MAIN_ROOM = GStructureProcessorTypes.register("pink_salt_main_room", MainRoomProcessor.CODEC);
    public static final Supplier<StructureProcessorType<NoWaterloggedProcessor>> NO_WATERLOGGED = GStructureProcessorTypes.register("no_waterlogged", NoWaterloggedProcessor.CODEC);
    public static final Supplier<StructureProcessorType<RawOreProcessor>> RAW_ORES = GStructureProcessorTypes.register("raw_ores", RawOreProcessor.CODEC);
    public static final Supplier<StructureProcessorType<ChiseledBookshelfProcessor>> CHISELED_BOOKSHELF = GStructureProcessorTypes.register("chiseled_bookshelf", ChiseledBookshelfProcessor.CODEC);
    public static final Supplier<StructureProcessorType<MultipleCandleProcessor>> MULTIPLE_CANDLES = GStructureProcessorTypes.register("multiple_candles", MultipleCandleProcessor.CODEC);
    public static final Supplier<StructureProcessorType<EchoAltarProcessor>> ECHO_ALTAR = GStructureProcessorTypes.register("echo_altar", EchoAltarProcessor.CODEC);

    public static <P extends StructureProcessor> Supplier<StructureProcessorType<P>> register(String string, MapCodec<P> codec) {
        StructureProcessorType type = () -> codec;
        return STRUCTURE_PROCESSOR_TYPES.register(string, () -> type);
    }
}

