/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.GlowFlare;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.entities.PalladiumBomb;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.entities.PinkSaltShard;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.entities.RopeDartProjectile;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.SpectatorVision;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.entities.SpectreFlare;
import net.orcinus.galosphere.entities.WeaponRack;

public class GEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"galosphere");
    public static final Supplier<EntityType<PalladiumBomb>> PALLADIUM_BOMB = ENTITY_TYPES.register("palladium_bomb", () -> EntityType.Builder.of(PalladiumBomb::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(10).build(GEntityTypes.create("palladium_bomb")));
    public static final Supplier<EntityType<Sparkle>> SPARKLE = ENTITY_TYPES.register("sparkle", () -> EntityType.Builder.of(Sparkle::new, (MobCategory)MobCategory.UNDERGROUND_WATER_CREATURE).sized(1.0f, 0.55f).clientTrackingRange(10).build(GEntityTypes.create("sparkle")));
    public static final Supplier<EntityType<Spectre>> SPECTRE = ENTITY_TYPES.register("spectre", () -> EntityType.Builder.of(Spectre::new, (MobCategory)MobCategory.AMBIENT).sized(0.5f, 0.5f).clientTrackingRange(8).updateInterval(2).build(GEntityTypes.create("spectre")));
    public static final Supplier<EntityType<GlowFlare>> GLOW_FLARE = ENTITY_TYPES.register("glow_flare", () -> EntityType.Builder.of(GlowFlare::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(GEntityTypes.create("glow_flare")));
    public static final Supplier<EntityType<SpectreFlare>> SPECTRE_FLARE = ENTITY_TYPES.register("spectre_flare", () -> EntityType.Builder.of(SpectreFlare::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(GEntityTypes.create("spectre_flare")));
    public static final Supplier<EntityType<Specterpillar>> SPECTERPILLAR = ENTITY_TYPES.register("specterpillar", () -> EntityType.Builder.of(Specterpillar::new, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.3f).clientTrackingRange(8).updateInterval(2).build(GEntityTypes.create("specterpillar")));
    public static final Supplier<EntityType<SpectatorVision>> SPECTATOR_VISION = ENTITY_TYPES.register("spectator_vision", () -> EntityType.Builder.of(SpectatorVision::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(5).build(GEntityTypes.create("spectator_vision")));
    public static final Supplier<EntityType<Berserker>> BERSERKER = ENTITY_TYPES.register("berserker", () -> EntityType.Builder.of(Berserker::new, (MobCategory)MobCategory.MONSTER).sized(1.4f, 2.2f).clientTrackingRange(16).fireImmune().build(GEntityTypes.create("berserker")));
    public static final Supplier<EntityType<Preserved>> PRESERVED = ENTITY_TYPES.register("preserved", () -> EntityType.Builder.of(Preserved::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8).build(GEntityTypes.create("preserved")));
    public static final Supplier<EntityType<PinkSaltPillar>> PINK_SALT_PILLAR = ENTITY_TYPES.register("pink_salt_pillar", () -> EntityType.Builder.of(PinkSaltPillar::new, (MobCategory)MobCategory.MISC).sized(0.7f, 1.5f).clientTrackingRange(16).fireImmune().build(GEntityTypes.create("pink_salt_pillar")));
    public static final Supplier<EntityType<PinkSaltShard>> PINK_SALT_SHARD = ENTITY_TYPES.register("pink_salt_shard", () -> EntityType.Builder.of(PinkSaltShard::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build(GEntityTypes.create("pink_salt_shard")));
    public static final Supplier<EntityType<Mole>> MOLE = ENTITY_TYPES.register("mole", () -> EntityType.Builder.of(Mole::new, (MobCategory)MobCategory.CREATURE).sized(0.85f, 0.8f).clientTrackingRange(8).build(GEntityTypes.create("mole")));
    public static final Supplier<EntityType<RopeDartProjectile>> ROPE_DART = ENTITY_TYPES.register("rope_dart", () -> EntityType.Builder.of(RopeDartProjectile::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5).build(GEntityTypes.create("rope_dart")));
    public static final Supplier<EntityType<WeaponRack>> WEAPON_RACK = ENTITY_TYPES.register("weapon_rack", () -> EntityType.Builder.of(WeaponRack::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build(GEntityTypes.create("weapon_rack")));

    private static String create(String name) {
        return Galosphere.id(name).getPath();
    }
}

