/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GFeatures;
import net.orcinus.galosphere.world.gen.features.config.CrystalSpikeConfig;
import net.orcinus.galosphere.world.gen.features.config.NoisePatchConfig;
import net.orcinus.galosphere.world.gen.features.config.PalladiumDustConfiguration;
import net.orcinus.galosphere.world.gen.features.config.PinkSaltStrawPatchConfig;
import net.orcinus.galosphere.world.gen.foliage.OpalFoliagePlacer;
import net.orcinus.galosphere.world.gen.trunks.OpalTrunkPlacer;

public class GConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_ALLURITE_CRYSTAL_FLOOR = GConfiguredFeatures.registerConfiguredFeature("large_allurite_crystal_floor");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_LUMIERE_CRYSTAL_FLOOR = GConfiguredFeatures.registerConfiguredFeature("large_lumiere_crystal_floor");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_ALLURITE_CRYSTAL_CEILING = GConfiguredFeatures.registerConfiguredFeature("large_allurite_crystal_ceiling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_LUMIERE_CRYSTAL_CEILING = GConfiguredFeatures.registerConfiguredFeature("large_lumiere_crystal_ceiling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ALLURITE_CRYSTAL_FLOOR = GConfiguredFeatures.registerConfiguredFeature("allurite_crystal_floor");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMIERE_CRYSTAL_FLOOR = GConfiguredFeatures.registerConfiguredFeature("lumiere_crystal_floor");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ALLURITE_CRYSTAL_CEILING = GConfiguredFeatures.registerConfiguredFeature("allurite_crystal_ceiling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMIERE_CRYSTAL_CEILING = GConfiguredFeatures.registerConfiguredFeature("lumiere_crystal_ceiling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SILVER_SMALL = GConfiguredFeatures.registerConfiguredFeature("ore_silver_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SILVER_LARGE = GConfiguredFeatures.registerConfiguredFeature("ore_silver_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BOWL_LICHEN = GConfiguredFeatures.registerConfiguredFeature("lichen_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LICHEN_VEGETATION = GConfiguredFeatures.registerConfiguredFeature("lichen_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LICHEN_PATCH = GConfiguredFeatures.registerConfiguredFeature("lichen_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LICHEN_CEILING_PATCH = GConfiguredFeatures.registerConfiguredFeature("lichen_ceiling_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRAVEL_PATCH = GConfiguredFeatures.registerConfiguredFeature("gravel_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LICHEN_CORDYCEPS = GConfiguredFeatures.registerConfiguredFeature("lichen_cordyceps");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LICHEN_COLUMN = GConfiguredFeatures.registerConfiguredFeature("lichen_column");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_SALT_GROUND_NOISE_PATCH = GConfiguredFeatures.registerConfiguredFeature("pink_salt_ground_noise_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_SALT_CEILING_NOISE_PATCH = GConfiguredFeatures.registerConfiguredFeature("pink_salt_ceiling_noise_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_SALT_STRAW_CEILING_PATCH = GConfiguredFeatures.registerConfiguredFeature("pink_salt_straw_ceiling_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_SALT_STRAW_FLOOR_PATCH = GConfiguredFeatures.registerConfiguredFeature("pink_salt_straw_floor_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OASIS = GConfiguredFeatures.registerConfiguredFeature("oasis");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BERSERKER = GConfiguredFeatures.registerConfiguredFeature("mobs/berserker");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALLADIUM_DUST = GConfiguredFeatures.registerConfiguredFeature("palladium_dust");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OPAL = GConfiguredFeatures.registerConfiguredFeature("opal");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> bootstapContext) {
        HolderGetter holderGetter = bootstapContext.lookup(Registries.CONFIGURED_FEATURE);
        FeatureUtils.register(bootstapContext, LARGE_ALLURITE_CRYSTAL_FLOOR, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.ALLURITE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.ALLURITE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)4, (int)7), CaveSurface.FLOOR, 0.25f));
        FeatureUtils.register(bootstapContext, LARGE_LUMIERE_CRYSTAL_FLOOR, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.LUMIERE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.LUMIERE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)4, (int)7), CaveSurface.FLOOR, 0.25f));
        FeatureUtils.register(bootstapContext, LARGE_ALLURITE_CRYSTAL_CEILING, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.ALLURITE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.ALLURITE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)4, (int)7), CaveSurface.CEILING, 0.25f));
        FeatureUtils.register(bootstapContext, LARGE_LUMIERE_CRYSTAL_CEILING, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.LUMIERE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.LUMIERE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)4, (int)7), CaveSurface.CEILING, 0.25f));
        FeatureUtils.register(bootstapContext, ALLURITE_CRYSTAL_FLOOR, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.ALLURITE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.ALLURITE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)1, (int)3), CaveSurface.FLOOR, 0.25f));
        FeatureUtils.register(bootstapContext, LUMIERE_CRYSTAL_FLOOR, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.LUMIERE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.LUMIERE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)1, (int)3), CaveSurface.FLOOR, 0.25f));
        FeatureUtils.register(bootstapContext, ALLURITE_CRYSTAL_CEILING, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.ALLURITE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.ALLURITE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)1, (int)3), CaveSurface.CEILING, 0.25f));
        FeatureUtils.register(bootstapContext, LUMIERE_CRYSTAL_CEILING, GFeatures.CRYSTAL_SPIKE.get(), (FeatureConfiguration)new CrystalSpikeConfig(((Block)GBlocks.LUMIERE_BLOCK.get()).defaultBlockState(), ((Block)GBlocks.LUMIERE_CLUSTER.get()).defaultBlockState(), ((Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)1, (int)3), CaveSurface.CEILING, 0.25f));
        FeatureUtils.register(bootstapContext, ORE_SILVER_SMALL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)GBlocks.PALLADIUM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)GBlocks.DEEPSLATE_PALLADIUM_ORE.get()).defaultBlockState())), 9));
        FeatureUtils.register(bootstapContext, ORE_SILVER_LARGE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)GBlocks.PALLADIUM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)GBlocks.DEEPSLATE_PALLADIUM_ORE.get()).defaultBlockState())), 12));
        FeatureUtils.register(bootstapContext, BOWL_LICHEN, GFeatures.BOWL_LICHEN.get(), (FeatureConfiguration)FeatureConfiguration.NONE);
        FeatureUtils.register(bootstapContext, LICHEN_VEGETATION, GFeatures.SIMPLE_WATERLOGGED_BLOCK.get(), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)GBlocks.BOWL_LICHEN.get()).defaultBlockState(), 4).add((Object)((Block)GBlocks.LICHEN_ROOTS.get()).defaultBlockState(), 14).add((Object)((BlockState)Blocks.GLOW_LICHEN.defaultBlockState().setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true))), 2))));
        FeatureUtils.register(bootstapContext, LICHEN_COLUMN, GFeatures.LICHEN_COLUMN.get(), (FeatureConfiguration)FeatureConfiguration.NONE);
        FeatureUtils.register(bootstapContext, LICHEN_PATCH, GFeatures.LICHEN_PATCH.get(), (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)GBlocks.LICHEN_MOSS.get())), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(LICHEN_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.8f, (IntProvider)UniformInt.of((int)4, (int)7), 0.3f));
        FeatureUtils.register(bootstapContext, LICHEN_CEILING_PATCH, GFeatures.LICHEN_PATCH.get(), (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)GBlocks.LICHEN_MOSS.get())), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(LICHEN_COLUMN), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.CEILING, (IntProvider)ConstantInt.of((int)3), 0.0f, 5, 0.05f, (IntProvider)UniformInt.of((int)4, (int)7), 0.3f));
        FeatureUtils.register(bootstapContext, GRAVEL_PATCH, (Feature)Feature.VEGETATION_PATCH, (FeatureConfiguration)new VegetationPatchConfiguration(GBlockTags.GRAVEL_MAY_REPLACE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.GRAVEL), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(LICHEN_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 0.8f, 2, 0.05f, (IntProvider)UniformInt.of((int)4, (int)7), 0.7f));
        FeatureUtils.register(bootstapContext, LICHEN_CORDYCEPS, GFeatures.LICHEN_CORDYCEPS_COLUMN.get(), (FeatureConfiguration)FeatureConfiguration.NONE);
        FeatureUtils.register(bootstapContext, PINK_SALT_GROUND_NOISE_PATCH, GFeatures.NOISE_PATCH.get(), (FeatureConfiguration)new NoisePatchConfig(CaveSurface.FLOOR));
        FeatureUtils.register(bootstapContext, PINK_SALT_CEILING_NOISE_PATCH, GFeatures.NOISE_PATCH.get(), (FeatureConfiguration)new NoisePatchConfig(CaveSurface.CEILING));
        FeatureUtils.register(bootstapContext, PINK_SALT_STRAW_CEILING_PATCH, GFeatures.PINK_SALT_STRAW_PATCH.get(), (FeatureConfiguration)new PinkSaltStrawPatchConfig((IntProvider)UniformInt.of((int)2, (int)8), (IntProvider)UniformInt.of((int)1, (int)4), (IntProvider)UniformInt.of((int)1, (int)3), Direction.UP));
        FeatureUtils.register(bootstapContext, PINK_SALT_STRAW_FLOOR_PATCH, GFeatures.PINK_SALT_STRAW_PATCH.get(), (FeatureConfiguration)new PinkSaltStrawPatchConfig((IntProvider)UniformInt.of((int)2, (int)8), (IntProvider)UniformInt.of((int)1, (int)4), (IntProvider)UniformInt.of((int)1, (int)3), Direction.DOWN));
        FeatureUtils.register(bootstapContext, OASIS, GFeatures.OASIS.get(), (FeatureConfiguration)FeatureConfiguration.NONE);
        FeatureUtils.register(bootstapContext, BERSERKER, GFeatures.BERSERKER.get(), (FeatureConfiguration)FeatureConfiguration.NONE);
        FeatureUtils.register(bootstapContext, PALLADIUM_DUST, GFeatures.PALLADIUM_DUST.get(), (FeatureConfiguration)new PalladiumDustConfiguration((TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)GBlocks.PALLADIUM_DUST.get()))));
        FeatureUtils.register(bootstapContext, OPAL, (Feature)Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)GBlocks.OPAL_LOG.get())), (TrunkPlacer)new OpalTrunkPlacer(7, 1, 0, (IntProvider)UniformInt.of((int)1, (int)2)), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)GBlocks.OPAL_LEAVES.get())), (FoliagePlacer)new OpalFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)0), (IntProvider)UniformInt.of((int)2, (int)6)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> bootstapContext, ResourceKey<ConfiguredFeature<?, ?>> resourceKey, F feature, FC featureConfiguration) {
        bootstapContext.register(resourceKey, (Object)new ConfiguredFeature(feature, featureConfiguration));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfiguredFeature(String id) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Galosphere.id(id));
    }
}

