/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class GBiomes {
    public static final List<ResourceKey<Biome>> BIOMES = Lists.newLinkedList();
    public static final ResourceKey<Biome> CRYSTAL_CANYONS = GBiomes.register("crystal_canyons");
    public static final ResourceKey<Biome> LICHEN_CAVES = GBiomes.register("lichen_caves");
    public static final ResourceKey<Biome> PINK_SALT_CAVES = GBiomes.register("pink_salt_caves");

    public static void bootstrap(BootstrapContext<Biome> bootstrapContext) {
        HolderGetter holderGetter = bootstrapContext.lookup(Registries.PLACED_FEATURE);
        HolderGetter holderGetter2 = bootstrapContext.lookup(Registries.CONFIGURED_CARVER);
        bootstrapContext.register(CRYSTAL_CANYONS, (Object)GBiomes.crystalCanyons((HolderGetter<PlacedFeature>)holderGetter, holderGetter2));
        bootstrapContext.register(LICHEN_CAVES, (Object)GBiomes.lichenCaves((HolderGetter<PlacedFeature>)holderGetter, holderGetter2));
        bootstrapContext.register(PINK_SALT_CAVES, (Object)GBiomes.pinkSaltCaves((HolderGetter<PlacedFeature>)holderGetter, holderGetter2));
    }

    public static Biome pinkSaltCaves(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter2) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter2);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.createGameMusic(GSoundEvents.MUSIC_PINK_SALT_CAVES);
        return GBiomes.biome(true, 0.5f, 0.5f, mobBuilder, biomeBuilder, music);
    }

    public static Biome lichenCaves(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter2) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter2);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.createGameMusic(GSoundEvents.MUSIC_LICHEN_CAVES);
        return GBiomes.biome(true, 0.5f, 0.5f, mobBuilder, biomeBuilder, music);
    }

    public static Biome crystalCanyons(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter2) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter2);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.createGameMusic(GSoundEvents.MUSIC_CRYSTAL_CANYONS);
        return GBiomes.biome(true, 0.5f, 0.5f, mobBuilder, biomeBuilder, music);
    }

    private static Biome biome(boolean bl, float f, float g, MobSpawnSettings.Builder builder, BiomeGenerationSettings.Builder builder2, @Nullable Music music) {
        return GBiomes.biome(bl, f, g, 4159204, 329011, null, null, builder, builder2, music);
    }

    private static Biome biome(boolean bl, float f, float g, int i, int j, @Nullable Integer integer, @Nullable Integer integer2, MobSpawnSettings.Builder builder, BiomeGenerationSettings.Builder builder2, @Nullable Music music) {
        BiomeSpecialEffects.Builder builder3 = new BiomeSpecialEffects.Builder().waterColor(i).waterFogColor(j).fogColor(12638463).skyColor(GBiomes.calculateSkyColor(f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music);
        if (integer != null) {
            builder3.grassColorOverride(integer.intValue());
        }
        if (integer2 != null) {
            builder3.foliageColorOverride(integer2.intValue());
        }
        return new Biome.BiomeBuilder().hasPrecipitation(bl).temperature(f).downfall(g).specialEffects(builder3.build()).mobSpawnSettings(builder.build()).generationSettings(builder2.build()).build();
    }

    protected static int calculateSkyColor(float p_194844_) {
        float $$1 = p_194844_ / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static ResourceKey<Biome> register(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Galosphere.id(name));
        BIOMES.add((ResourceKey<Biome>)key);
        return key;
    }
}

