/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.specterpillar;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class Burrow
extends Behavior<Specterpillar> {
    public Burrow() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.CAN_BURY.get(), (Object)MemoryStatus.VALUE_PRESENT, GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get(), (Object)MemoryStatus.VALUE_PRESENT), Mth.ceil((float)65.0f));
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Specterpillar livingEntity) {
        return livingEntity.onGround() && this.getTargetPos(livingEntity).isPresent() && this.getTargetPos(livingEntity).get().distManhattan((Vec3i)livingEntity.blockPosition()) <= 0;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Specterpillar livingEntity, long l) {
        Optional<BlockPos> targetPos = this.getTargetPos(livingEntity);
        if (targetPos.isEmpty()) {
            return false;
        }
        BlockPos blockPos = targetPos.get();
        if (serverLevel.getBlockState(blockPos).isAir() && serverLevel.getBlockState(blockPos.below()).is((Block)GBlocks.LICHEN_MOSS.get())) {
            return true;
        }
        livingEntity.setPose(Pose.STANDING);
        livingEntity.getBrain().eraseMemory(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get());
        return false;
    }

    protected void start(ServerLevel serverLevel, Specterpillar livingEntity, long l) {
        this.getTargetPos(livingEntity).ifPresent(blockPos -> {
            if (blockPos.distManhattan((Vec3i)livingEntity.blockPosition()) <= 0 && livingEntity.onGround()) {
                livingEntity.setPose(Pose.DIGGING);
            }
        });
    }

    protected void stop(ServerLevel serverLevel, Specterpillar livingEntity, long l) {
        if (this.timedOut(l)) {
            this.getTargetPos(livingEntity).filter(blockPos -> serverLevel.getBlockState(blockPos).isAir()).ifPresentOrElse(pos -> {
                serverLevel.setBlock(pos, (BlockState)((BlockState)((Block)GBlocks.LICHEN_CORDYCEPS.get()).defaultBlockState().setValue((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(1))).setValue((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), 2);
                livingEntity.discard();
            }, () -> livingEntity.getBrain().eraseMemory(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get()));
        }
    }

    public Optional<BlockPos> getTargetPos(Specterpillar specterpillar) {
        return specterpillar.getBrain().getMemory(GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get());
    }
}

