/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.sparkle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.variants.SparkleVariant;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class WalkToPollinatedCluster
extends Behavior<Sparkle> {
    private int sniffingTicks;
    private int stuckTicks;
    private boolean setCooldownOnly = false;

    public WalkToPollinatedCluster() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get(), (Object)MemoryStatus.VALUE_PRESENT, GMemoryModuleTypes.POLLINATED_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, Sparkle entity) {
        return !entity.isBaby() && this.getNearestCluster(entity).isPresent() && !entity.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET) && !entity.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canStillUse(ServerLevel world, Sparkle entity, long p_22547_) {
        if (this.stuckTicks > 200) {
            this.setCooldownOnly = true;
            return false;
        }
        if (this.sniffingTicks <= 0) return false;
        if (!this.getNearestCluster(entity).map(arg_0 -> ((ServerLevel)world).getBlockState(arg_0)).filter(this::isPollinatedCluster).isPresent()) return false;
        return true;
    }

    private boolean isPollinatedCluster(BlockState state) {
        return state.is(Blocks.AMETHYST_CLUSTER) || state.getBlock() instanceof PollinatedClusterBlock && (Boolean)state.getValue((Property)PollinatedClusterBlock.POLLINATED) == false;
    }

    protected void start(ServerLevel world, Sparkle entity, long p_22542_) {
        this.sniffingTicks = 100;
    }

    protected void tick(ServerLevel p_22551_, Sparkle entity, long p_22553_) {
        this.getNearestCluster(entity).ifPresent(blockPos -> {
            boolean flag;
            boolean bl = flag = (float)entity.blockPosition().distManhattan((Vec3i)blockPos) <= (entity.isInWater() ? 2.0f : 1.0f);
            if (flag) {
                entity.getNavigation().stop();
                --this.sniffingTicks;
            } else {
                ++this.stuckTicks;
            }
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)entity, (BlockPos)blockPos, (float)2.0f, (int)0);
        });
    }

    protected void stop(ServerLevel world, Sparkle entity, long p_22550_) {
        this.getNearestCluster(entity).filter(blockPos -> this.isPollinatedCluster(world.getBlockState(blockPos))).ifPresent(blockPos -> {
            entity.getBrain().eraseMemory(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get());
            if (!this.setCooldownOnly) {
                BlockState state = world.getBlockState(blockPos);
                SparkleVariant variant = (SparkleVariant)entity.getVariant().value();
                Optional<Block> crystal = variant.crystal().filter(BlockItem.class::isInstance).map(BlockItem.class::cast).map(BlockItem::getBlock);
                if (crystal.isPresent() && state.is(crystal.get()) && variant.glinted().isPresent()) {
                    Block placeState = variant.glinted().get();
                    world.setBlock(blockPos, placeState.withPropertiesOf(state), 2);
                    world.playSound(null, blockPos, placeState.defaultBlockState().getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.levelEvent(2005, blockPos, 0);
                    entity.getBrain().eraseMemory(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get());
                }
            }
            entity.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.POLLINATED_COOLDOWN.get(), (Object)Unit.INSTANCE, 100L);
        });
        this.stuckTicks = 0;
        this.setCooldownOnly = false;
    }

    protected boolean timedOut(long p_22537_) {
        return false;
    }

    private Optional<BlockPos> getNearestCluster(Sparkle entity) {
        return entity.getBrain().getMemory(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER.get());
    }
}

