/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.berserker;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class HaliteAttack
extends Behavior<Berserker> {
    private static final int MAX_DURATION = 46;

    public HaliteAttack() {
        super(Map.of(GMemoryModuleTypes.HALITE_ATTACK_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryStatus.VALUE_PRESENT, GMemoryModuleTypes.IS_SMASHING.get(), MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_IMPALING.get(), MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_SUMMONING.get(), MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_HALITE_ATTACKING.get(), MemoryStatus.REGISTERED), 46);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker livingEntity) {
        Iterator<LivingEntity> entities = this.getEntities(livingEntity);
        return livingEntity.shouldAttack() && livingEntity.hasPose(Pose.STANDING) && entities != null && entities.hasNext();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker livingEntity, long l) {
        livingEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        livingEntity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Iterator<LivingEntity> entities = this.getEntities(livingEntity);
        if (entities == null || !entities.hasNext()) {
            return;
        }
        entities.forEachRemaining(living -> {
            double distance;
            Vec3 vec3 = livingEntity.getEyePosition();
            Vec3 vec32 = living.getEyePosition().subtract(vec3);
            Vec3 vec33 = vec32.normalize();
            for (double i = 0.0; i < (double)Mth.floor((double)vec32.length()); i += distance) {
                distance = Mth.nextDouble((RandomSource)living.getRandom(), (double)0.5, (double)1.0);
                Vec3 vec34 = livingEntity.getEyePosition().add(vec33.scale(i));
                serverLevel.sendParticles((ParticleOptions)GParticleTypes.PINK_SALT_FALLING_DUST.get(), vec34.x, vec34.y, vec34.z, 3, 0.0, 0.0, 0.0, 1.0);
            }
            living.addEffect(new MobEffectInstance(GMobEffects.HALITE_CURSE, 1200, 0, false, false));
        });
        livingEntity.setPhase(Berserker.Phase.HALITE_ATTACK);
        livingEntity.playSound(GSoundEvents.BERSERKER_HALITE_CURSE.get(), 3.0f, 1.0f);
        livingEntity.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.IS_HALITE_ATTACKING.get(), (Object)Unit.INSTANCE, 46L);
    }

    @Nullable
    private Iterator<LivingEntity> getEntities(Berserker berserker) {
        Optional optional = berserker.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return optional.map(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.findAll(this::canAffectEntity).iterator()).orElse(null);
    }

    private boolean canAffectEntity(LivingEntity living) {
        TamableAnimal tamableAnimal;
        if (!living.isAlive()) {
            return false;
        }
        boolean flag = living instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)living).getOwner() != null;
        boolean flag1 = living instanceof AbstractGolem && !(living instanceof Enemy);
        boolean flag2 = !living.hasEffect(GMobEffects.HALITE_CURSE);
        return (flag || flag1) && flag2;
    }

    protected void stop(ServerLevel serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
        livingEntity.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.HALITE_ATTACK_COOLDOWN.get(), (Object)Unit.INSTANCE, 100L);
    }
}

