/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.sensors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.orcinus.galosphere.entities.Preserved;

public class PreservedEntitySensor
extends NearestLivingEntitySensor<Preserved> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    protected void doTick(ServerLevel serverLevel, Preserved preserved) {
        super.doTick(serverLevel, (LivingEntity)preserved);
        PreservedEntitySensor.getClosest(preserved, livingEntity -> livingEntity.getType() == EntityType.PLAYER).or(() -> PreservedEntitySensor.getClosest(preserved, livingEntity -> livingEntity.getType() != EntityType.PLAYER)).ifPresentOrElse(livingEntity -> preserved.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, livingEntity), () -> preserved.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }

    private static Optional<LivingEntity> getClosest(Preserved preserved, Predicate<LivingEntity> predicate) {
        return preserved.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(preserved::canTargetEntity).filter(predicate).findFirst();
    }
}

