/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.sensors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.entities.Berserker;

public class BerserkerEntitySensor
extends NearestLivingEntitySensor<Berserker> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    protected void doTick(ServerLevel serverLevel, Berserker berserker) {
        super.doTick(serverLevel, (LivingEntity)berserker);
        BerserkerEntitySensor.getClosest(berserker, livingEntity -> livingEntity.getType() == EntityType.PLAYER).or(() -> BerserkerEntitySensor.getClosest(berserker, livingEntity -> livingEntity.getType() != EntityType.PLAYER)).ifPresentOrElse(livingEntity -> berserker.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, livingEntity), () -> berserker.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }

    private static Optional<LivingEntity> getClosest(Berserker berserker, Predicate<LivingEntity> predicate) {
        return berserker.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(entity -> {
            Level patt0$temp = berserker.level();
            if (!(patt0$temp instanceof ServerLevel)) return false;
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            if (!berserker.canTargetEntity((Entity)entity)) return false;
            return true;
        }).filter(predicate).findFirst();
    }
}

