/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.entities.ai.tasks.specterpillar.Burrow;
import net.orcinus.galosphere.entities.ai.tasks.specterpillar.PathfindBurrowSpot;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class SpecterpillarAi {
    public static Brain<?> makeBrain(Brain<Specterpillar> brain) {
        SpecterpillarAi.initCoreActivity(brain);
        SpecterpillarAi.initIdleActivity(brain);
        SpecterpillarAi.initDigActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Specterpillar> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(0.5f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<Specterpillar> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new FollowTemptation(livingEntity -> Float.valueOf(0.25f))), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.25f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.25f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(GMemoryModuleTypes.CAN_BURY.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initDigActivity(Brain<Specterpillar> brain) {
        brain.addActivityWithConditions(Activity.DIG, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new PathfindBurrowSpot())), (Object)Pair.of((Object)1, (Object)((Object)new Burrow()))), (Set)ImmutableSet.of((Object)Pair.of(GMemoryModuleTypes.CAN_BURY.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(Specterpillar specterpillar) {
        specterpillar.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.DIG, (Object)Activity.IDLE));
    }
}

