/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.orcinus.galosphere.datagen.GAdvancementProvider;
import net.orcinus.galosphere.datagen.GBiomeTagsProvider;
import net.orcinus.galosphere.datagen.GBlockTagsProvider;
import net.orcinus.galosphere.datagen.GDataMapProvider;
import net.orcinus.galosphere.datagen.GDatapackBuiltinEntriesProvider;
import net.orcinus.galosphere.datagen.GEnchantmentTagsProvider;
import net.orcinus.galosphere.datagen.GEntityTypeTagsProvider;
import net.orcinus.galosphere.datagen.GItemTagsProvider;
import net.orcinus.galosphere.datagen.GLanguageProvider;
import net.orcinus.galosphere.datagen.GLootModifierProvider;
import net.orcinus.galosphere.datagen.GLootTableProvider;
import net.orcinus.galosphere.datagen.GRecipeProvider;
import net.orcinus.galosphere.datagen.GStructureTagsProvider;

@EventBusSubscriber(modid="galosphere", bus=EventBusSubscriber.Bus.MOD)
public class GDataGenerator {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        dataGenerator.addProvider(server, (DataProvider)new GLanguageProvider(packOutput));
        dataGenerator.addProvider(server, (DataProvider)new GRecipeProvider(packOutput, lookupProvider));
        GBlockTagsProvider blockTagsProvider = new GBlockTagsProvider(packOutput, lookupProvider, helper);
        dataGenerator.addProvider(server, (DataProvider)blockTagsProvider);
        dataGenerator.addProvider(server, (DataProvider)new GAdvancementProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(server, (DataProvider)new GEntityTypeTagsProvider(packOutput, lookupProvider, helper));
        dataGenerator.addProvider(server, (DataProvider)new GStructureTagsProvider(packOutput, lookupProvider, helper));
        dataGenerator.addProvider(server, (DataProvider)new GItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        dataGenerator.addProvider(server, (DataProvider)new GBiomeTagsProvider(packOutput, lookupProvider, helper));
        dataGenerator.addProvider(server, (DataProvider)new GEnchantmentTagsProvider(packOutput, lookupProvider, helper));
        dataGenerator.addProvider(server, (DataProvider)new GDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(server, (DataProvider)new GDataMapProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(server, (DataProvider)new GLootModifierProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(server, (DataProvider)new GLootTableProvider(packOutput, lookupProvider));
    }
}

