/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.WeaponRackModel;
import net.orcinus.galosphere.entities.WeaponRack;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class WeaponRackRenderer
extends EntityRenderer<WeaponRack> {
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/weapon_rack/weapon_rack.png");
    private final ItemRenderer itemRenderer;
    private final WeaponRackModel model;

    public WeaponRackRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new WeaponRackModel(context.bakeLayer(GModelLayers.WEAPON_RACK));
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(WeaponRack entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float g;
        float f;
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        Direction direction = entity.getDirection();
        Vec3 vec3 = this.getRenderOffset(entity, partialTick);
        poseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
        poseStack.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        if (direction.getAxis().isHorizontal()) {
            f = 0.0f;
            g = 180.0f - direction.toYRot();
        } else {
            f = -90 * direction.getAxisDirection().getStep();
            g = 180.0f;
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(f));
        poseStack.mulPose(Axis.YP.rotationDegrees(g));
        poseStack.mulPose(Axis.ZP.rotationDegrees(135.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)entity.getRotation() * 360.0f / 8.0f));
        poseStack.pushPose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
        poseStack.translate(0.0f, -1.0f, 0.0f);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        float shift = entity.getXShift();
        float yShift = entity.getYShift() + 1.0f;
        float zShift = entity.getZShift();
        poseStack.translate(shift, yShift, zShift);
        float pitch = entity.getPitchRotation();
        float yaw = entity.getYawRotation();
        float roll = entity.getRollRotation();
        if (!entity.getItem().isEmpty()) {
            poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
            poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
            poseStack.mulPose(Axis.ZP.rotationDegrees(roll));
            poseStack.scale(1.0f, 1.0f, 1.0f);
            ItemDisplayContext context = entity.getItem().is(Items.TRIDENT) ? ItemDisplayContext.NONE : ItemDisplayContext.HEAD;
            this.itemRenderer.renderStatic(entity.getItem(), context, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, entity.level(), entity.getId());
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(WeaponRack entity) {
        return TEXTURE;
    }

    public Vec3 getRenderOffset(WeaponRack entity, float partialTicks) {
        return new Vec3((double)((float)entity.getDirection().getStepX() * 0.3f), -0.25, (double)((float)entity.getDirection().getStepZ() * 0.3f));
    }
}

