/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.entities.SpectatorVision;

@OnlyIn(value=Dist.CLIENT)
public class SpectatorVisionRenderer
extends EntityRenderer<SpectatorVision> {
    private static final Function<Integer, ResourceLocation> FUNCTION = integer -> Galosphere.id("textures/entity/spectator_vision/spectator_vision_" + integer + ".png");

    public SpectatorVisionRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SpectatorVision spectatorVision, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float size = 1.5f;
        float sin = Mth.sin((float)((float)spectatorVision.tickCount / 4.0f)) / 16.0f;
        poseStack.scale(size, size, size);
        poseStack.translate(0.0f, sin, 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(spectatorVision)));
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, packedLight, 0.0f, 0, 0, 1);
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, packedLight, 1.0f, 0, 1, 1);
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, packedLight, 1.0f, 1, 1, 0);
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
        super.render((Entity)spectatorVision, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    protected int getBlockLightLevel(SpectatorVision entity, BlockPos blockPos) {
        return entity.getPhase();
    }

    public ResourceLocation getTextureLocation(SpectatorVision entity) {
        return FUNCTION.apply(entity.getPhase() + 1);
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, int i, float f, int j, int k, int l) {
        vertexConsumer.addVertex(pose, f - 0.5f, (float)j - 0.5f, 0.0f).setColor(-1).setUv((float)k, (float)l).setOverlay(OverlayTexture.NO_OVERLAY).setLight(i).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

