/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EchoCurseBreakParticle
extends TextureSheetParticle {
    public EchoCurseBreakParticle(ClientLevel clientLevel, double d, double e, double f) {
        super(clientLevel, d, e, f);
        this.quadSize = 3.0f;
        this.lifetime = 30;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        this.alpha = 1.0f - Mth.clamp((float)(((float)this.age + f) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        this.renderRotatedQuad(vertexConsumer, camera, Axis.XP.rotation(1.5707964f), f);
        this.renderRotatedQuad(vertexConsumer, camera, Axis.XN.rotation(1.5707964f), f);
    }

    public float getQuadSize(float f) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + f) / (float)this.lifetime * 0.75f), (float)0.0f, (float)1.0f);
    }

    protected int getLightColor(float f) {
        return 240;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            EchoCurseBreakParticle curseParticle = new EchoCurseBreakParticle(clientLevel, d, e, f);
            curseParticle.pickSprite(this.sprite);
            curseParticle.setAlpha(1.0f);
            return curseParticle;
        }
    }
}

