/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.EchoAltarBlock;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GParticleTypes;
import org.jetbrains.annotations.Nullable;

public class EchoAltarBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    public static final int MAX_CURSE_BREAKING_TICKS = 100;
    private int curseBreakingTicks = 100;
    public float rot;
    public float oRot;
    public float tRot;

    public EchoAltarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(GBlockEntityTypes.ECHO_ALTAR.get(), blockPos, blockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, EchoAltarBlockEntity entity) {
        float g;
        entity.oRot = entity.rot;
        Player player = level.getNearestPlayer((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, 3.0, false);
        if (player != null) {
            double d = player.getX() - ((double)blockPos.getX() + 0.5);
            double e = player.getZ() - ((double)blockPos.getZ() + 0.5);
            entity.tRot = (float)Mth.atan2((double)e, (double)d) + 14.2f;
        } else {
            entity.tRot += 0.02f;
        }
        while (entity.rot >= (float)Math.PI) {
            entity.rot -= (float)Math.PI * 2;
        }
        while (entity.rot < (float)(-Math.PI)) {
            entity.rot += (float)Math.PI * 2;
        }
        while (entity.tRot >= (float)Math.PI) {
            entity.tRot -= (float)Math.PI * 2;
        }
        while (entity.tRot < (float)(-Math.PI)) {
            entity.tRot += (float)Math.PI * 2;
        }
        for (g = entity.tRot - entity.rot; g >= (float)Math.PI; g -= (float)Math.PI * 2) {
        }
        while (g < (float)(-Math.PI)) {
            g += (float)Math.PI * 2;
        }
        entity.rot += g * 0.4f;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, EchoAltarBlockEntity entity) {
        ItemStack itemStack = entity.getItem(0);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!itemStack.isEmpty() && ((Boolean)blockState.getValue((Property)EchoAltarBlock.BLOOM)).booleanValue()) {
            if (entity.curseBreakingTicks > 0) {
                --entity.curseBreakingTicks;
                serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SCULK.defaultBlockState()), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.35, (double)blockPos.getZ() + 0.5, 1, 0.1, 0.0, 0.1, 0.0);
                if (serverLevel.getGameTime() % 4L == 0L) {
                    serverLevel.playSound(null, blockPos, SoundEvents.SCULK_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                EnchantmentHelper.updateEnchantments((ItemStack)itemStack, mutable -> mutable.removeIf(holder -> holder.is(EnchantmentTags.CURSE)));
                if (itemStack.is(Items.ENCHANTED_BOOK)) {
                    itemStack = new ItemStack((ItemLike)Items.BOOK);
                }
                entity.setItem(0, itemStack);
                level.playSound(null, blockPos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                entity.curseBreakingTicks = 100;
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)EchoAltarBlock.BLOOM, (Comparable)Boolean.valueOf(false)), 3);
                serverLevel.sendParticles((ParticleOptions)GParticleTypes.ECHO_CURSE_BREAK.get(), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.1, (double)blockPos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (!this.trySaveLootTable(compoundTag)) {
            ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        }
        if (this.curseBreakingTicks > 0) {
            compoundTag.putInt("CurseBreakingTicks", this.curseBreakingTicks);
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.curseBreakingTicks = compoundTag.getInt("CurseBreakingTicks");
        if (!this.tryLoadLootTable(compoundTag)) {
            ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.galosphere.echoing_altar");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return null;
    }

    public boolean canOpen(Player player) {
        return false;
    }

    public int getContainerSize() {
        return 1;
    }
}

