/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.blocks.blockentities.ShadowFrameBlockEntity;
import org.jetbrains.annotations.Nullable;

public class ShadowFrameBlock
extends BaseEntityBlock {
    public static final MapCodec<ShadowFrameBlock> CODEC = ShadowFrameBlock.simpleCodec(ShadowFrameBlock::new);
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public ShadowFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level world = blockPlaceContext.getLevel();
        BlockPos pos = blockPlaceContext.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(pos))), 2);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public float getDestroyProgress(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.getValue((Property)FILLED)).booleanValue() && (blockEntity = blockGetter.getBlockEntity(blockPos)) instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
            return shadowFrameBlockEntity.getCopiedState().getDestroyProgress(player, blockGetter, blockPos);
        }
        return super.getDestroyProgress(blockState, player, blockGetter, blockPos);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)FILLED) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public boolean skipRendering(BlockState blockState, BlockState blockState2, Direction direction) {
        if (blockState2.is((Block)this) && !((Boolean)blockState2.getValue((Property)FILLED)).booleanValue()) {
            return true;
        }
        return super.skipRendering(blockState, blockState2, direction);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)FILLED)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
            BlockState copiedState = shadowFrameBlockEntity.getCopiedState();
            return copiedState.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockItem blockItem;
        ItemStack stack = player.getItemInHand(interactionHand);
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(player, interactionHand, stack, blockHitResult);
        Item item = stack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() == this) {
            return ItemInteractionResult.FAIL;
        }
        item = level.getBlockEntity(blockPos);
        if (item instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)item;
            if (shadowFrameBlockEntity.isWaxed()) {
                return ItemInteractionResult.FAIL;
            }
            if (stack.getItem() instanceof HoneycombItem) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockPos, stack);
                }
                stack.consume(1, (LivingEntity)player);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
                level.levelEvent(player, 3003, blockPos, 0);
                shadowFrameBlockEntity.setWaxed(true);
                return ItemInteractionResult.SUCCESS;
            }
            if (!((Boolean)blockState.getValue((Property)FILLED)).booleanValue()) {
                BlockItem blockItem2;
                Block block;
                BlockState stateForPlacement;
                Item item2 = stack.getItem();
                if (item2 instanceof BlockItem && this.canBeFramed(level, blockPlaceContext, stateForPlacement = (block = (blockItem2 = (BlockItem)item2).getBlock()).getStateForPlacement(blockPlaceContext))) {
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    level.playSound(player, blockPos, stateForPlacement.getSoundType().getPlaceSound(), SoundSource.BLOCKS, (this.soundType.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
                    shadowFrameBlockEntity.interact(stateForPlacement, level, blockPos, blockState);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (stack.isEmpty()) {
                if (!level.isClientSide) {
                    level.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue((Property)FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)), 2);
                    level.playSound(null, blockPos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.getInventory().add(new ItemStack((ItemLike)shadowFrameBlockEntity.getCopiedState().getBlock().asItem()));
                }
                shadowFrameBlockEntity.setCopiedState(Blocks.AIR.defaultBlockState());
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    private boolean canBeFramed(Level level, BlockPlaceContext blockPlaceContext, BlockState stateForPlacement) {
        BlockPos clickedPos = blockPlaceContext.getClickedPos();
        return stateForPlacement != null && !(stateForPlacement.getBlock() instanceof EntityBlock) && Block.isShapeFullBlock((VoxelShape)stateForPlacement.getShape((BlockGetter)level, clickedPos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FILLED, WATERLOGGED, LEVEL, POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ShadowFrameBlockEntity(blockPos, blockState);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return (Boolean)blockState.getValue((Property)FILLED) == false;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return super.getShape(blockState, blockGetter, blockPos, collisionContext);
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.getValue((Property)POWERED) == false ? Shapes.empty() : blockState.getShape(blockGetter, blockPos);
    }

    public List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        List drops = super.getDrops(blockState, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
            drops.addAll(shadowFrameBlockEntity.getCopiedState().getDrops(builder));
        }
        return drops;
    }
}

