/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.network;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.game.ArkaniaGame;
import br.com.arkanis.arkanyamon.menu.ArkaniaGameMenu;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.sound.ModSounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class RetreatPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RetreatPayload> TYPE = new CustomPacketPayload.Type(Arkanyamon.id("retreat"));
    public static final RetreatPayload PAYLOAD = new RetreatPayload();
    public static final StreamCodec<ByteBuf, RetreatPayload> STREAM_CODEC = StreamCodec.unit((Object)PAYLOAD);

    private RetreatPayload() {
    }

    public static void handleServer(RetreatPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player sender = context.player();
            if (sender instanceof LivingEntityMixed) {
                LivingEntityMixed mixed = (LivingEntityMixed)sender;
                AbstractContainerMenu patt0$temp = sender.containerMenu;
                if (patt0$temp instanceof ArkaniaGameMenu) {
                    ArkaniaGameMenu menu = (ArkaniaGameMenu)patt0$temp;
                    CardPlayer player = mixed.charta_getCardPlayer();
                    ArkaniaGame game = (ArkaniaGame)menu.getGame();
                    if (game.getCurrentPlayer() == player) {
                        game.getActiveCard(player).ifPresent(active -> {
                            if (active.canRetreat()) {
                                game.getPlayerHand(player).add((Card)active);
                                game.getActiveSlot(player).clear();
                                game.play(player, (Component)Component.literal((String)"Recuou ").append(active.getName()));
                                player.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                            }
                        });
                    }
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

