/*
 * Decompiled with CFR 0.152.
 */
package br.com.arkanis.arkanyamon.network;

import br.com.arkanis.arkanyamon.Arkanyamon;
import br.com.arkanis.arkanyamon.ScheduledGiftData;
import br.com.arkanis.arkanyamon.item.ArkaniaPackItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class OpenPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<OpenPayload> TYPE = new CustomPacketPayload.Type(Arkanyamon.id("open"));
    public static final OpenPayload PAYLOAD = new OpenPayload();
    public static final StreamCodec<ByteBuf, OpenPayload> STREAM_CODEC = StreamCodec.unit((Object)PAYLOAD);

    private OpenPayload() {
    }

    public static void handleServer(OpenPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                for (InteractionHand hand : InteractionHand.values()) {
                    ItemStack stack = player.getItemInHand(hand);
                    if (!(stack.getItem() instanceof ArkaniaPackItem)) continue;
                    int i = 0;
                    for (ItemStack card : ArkaniaPackItem.getCardItems(stack)) {
                        if (card.isEmpty()) continue;
                        ScheduledGiftData.get(serverPlayer.server).schedule(serverPlayer, card, 60 + 2 * i);
                        ++i;
                    }
                    stack.shrink(1);
                    return;
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

